#version 140
#extension GL_ARB_compatibility: enable

in  vec3 in_position;
in  vec3 in_normal;
in  vec2 in_texcoords;

out vec3 normal, lightDir, eyeVec;
out vec2 tex;
uniform float musictime;
uniform float musicdata[256];
uniform int state;

void main(void) {

	normal = gl_NormalMatrix * in_normal;
	tex = in_texcoords;
	
	// Lightcalc
	vec3 vVertex = vec3(gl_ModelViewMatrix * vec4(in_position.xyz, 1.0));
	lightDir = vec3(gl_LightSource[0].position.xyz - vVertex);
	eyeVec = -vVertex;

	gl_FrontColor = vec4(1.0);	
 
  gl_Position = gl_ProjectionMatrix * gl_ModelViewMatrix * vec4(in_position.xyz, 1.0);
}