from itertools import product
from coord import Coord
from operator import itemgetter
import math 
#from mapwindow import MapWindowThread
import random

class PFWorld(object):
    debug = False
    tiles = []
    bombs = []
    enemies = []
    bombRange = 2
    width = 0
    height = 0
    safeTiles = set()
    pf = []
    directions = { 'UP': Coord(x=0, y=-1), 'LEFT': Coord(x=-1, y=0), 'RIGHT': Coord(x=1, y=0), 'DOWN': Coord(x=0, y=1) }
    #debugwindow = None
    previousPositions = []

    def __init__(self, size, tiles):
        if self.debug:
            print "Constructing world object. Size: {0}".format(size)
        #self.debugwindow = MapWindowThread()
        #self.debugwindow.daemon = True
        self.update(size, tiles)


    def update(self, size, tiles):
        if self.debug:
            print "Updating world object. Size: {0}".format(size)
 
        self.width = size.x
        self.height = size.y
        self.pf = [[0.0 for x in range(self.width)] for y in range(self.height)]
        self.tiles = [[square for square in row] for row in tiles]

    def updateBombs(self, bombs):
        # Sort bombs so the ones with lowest state is first
        self.bombs = sorted(bombs, key=itemgetter("state"))

        # Make sure we know the actual explosion time for bombs
        for explosion in self.bombs:
            for bomb in self.bombs:
                if explosion["x"] != bomb["x"] or explosion["y"] != bomb["y"]:
                    if bomb["x"] >= explosion["x"] - 2 and bomb["x"] <= explosion["x"] + 2 and bomb["y"] == explosion["y"]:
                        bomb["state"] = explosion["state"]

                    if bomb["y"] >= explosion["y"] - 2 and bomb["y"] <= explosion["y"] + 2 and bomb["x"] == explosion["x"]:
                        bomb["state"] = explosion["state"]

    def updateEnemies(self, enemies):
        self.enemies = enemies

    def isExplodable(self, tile):
        return (self.tiles[tile.y][tile.x] == "#")

    def moveRequired(self, fromTile, toTile):
        for direction, move in self.directions.iteritems():
            if (fromTile + move) == toTile:
                return direction

        return None

    def isInsideMap(self, p):
        return (p.x < self.width and p.y < self.height and p.x > -1 and p.y > -1)

    def passableTile(self, tile):
        return (self.tiles[tile.y][tile.x] == ".")

    def hasBomb(self, tile):
        for bomb in self.bombs:
            if (tile.x == bomb["x"] and tile.y == bomb["y"]):
                return True

        return False

    def deadlyWithin(self, tile, turns):
        for bomb in self.bombs:
            if (tile.x >= bomb["x"] - 2 and tile.x <= bomb["x"] + 2 and tile.y == bomb["y"] and bomb["state"] <= turns):
                return True

            if (tile.y >= bomb["y"] - 2 and tile.y <= bomb["y"] + 2 and tile.x == bomb["x"] and bomb["state"] <= turns):
                return True                

        return False

    def getMoveFromPotensialFields(self, ownPosition):
        #if len(self.previousPositions) > 0 and self.previousPositions[0] != ownPosition:
        self.previousPositions.insert(0, ownPosition)
        self.previousPositions = self.previousPositions[:4]

        cmd = [None]
        m = self.pf[ownPosition.y][ownPosition.x]
        for direction, offset in self.directions.iteritems():
            tile = ownPosition + offset 

            if self.pf[tile.y][tile.x] > m:
                m = self.pf[tile.y][tile.x]
                cmd = [direction]

            elif self.pf[tile.y][tile.x] == m:
                cmd.append(direction)

        return random.choice(cmd) #random.choice(["UP", "LEFT", "DOWN", "RIGHT"])

    def exitsAvailable(self, t):
        exits = 0
        for direction, offset in self.directions.iteritems():
            tile = t + offset
            if self.isInsideMap(tile) and self.passableTile(tile) and not self.deadlyWithin(tile, 5):
                exits += 1

        return exits

    def findSafeTiles(self):
        self.safeTiles = set()
        for y in range(1, self.height):
            for x in range(1, self.width):
                tile = Coord(x=x, y=y)
                if self.passableTile(tile) and not self.deadlyWithin(tile, 5):
                    self.safeTiles.add(tile)

        return self.safeTiles

    def hasExits(self, tile):
        for t in tile.neighbours():
            if t in self.safeTiles:
                return True

        return False

    def calcBombFields(self, es, bomb, x, y, maxDanger, hasExists):
        if self.isInsideMap(Coord(x=bomb["x"] + x, y=bomb["y"] + y)):
            if not hasExists:
                es[bomb["y"] + y][bomb["x"] + x] = max(es[bomb["y"] + y][bomb["x"] + x], maxDanger)
            else:
                f = maxDanger - ((abs(y) + abs(x)) * 5)
                es[bomb["y"] + y][bomb["x"] + x] = max(es[bomb["y"] + y][bomb["x"] + x], f)

        return es

    def calculatePotensialFields(self):
        calcBombs = True
        calcWalls = True
        calcEnemies = True
        bombTicks = 5.0

        self.pf = [[0.0 for x in range(self.width)] for y in range(self.height)]
        # Store safe tiles for later
        self.findSafeTiles()
                   
        if calcEnemies:
            es = [[0.0 for x in range(self.width)] for y in range(self.height)]
            for enemy in self.enemies:
                pos = Coord(x=enemy["x"], y=enemy["y"])

                for y in range(1, self.height):
                    for x in range(1, self.width):
                        if es[y][x] != -50:
                            f = math.sqrt((pos.x - x)**2 + (pos.y - y)**2) * 4
                            es[y][x] = max(es[y][x], max(0, 50 - f) / 1.5)

                es[pos.y][pos.x] = -50.0

            for y in range(self.height):
                for x in range(self.width):
                    self.pf[y][x] += es[y][x]

        if calcBombs:
            es = [[0.0 for x in range(self.width)] for y in range(self.height)]
            for bomb in self.bombs:
                maxDanger = 50 * ((bombTicks - bomb["state"]) / bombTicks)

                es[bomb['y']][bomb['x']] = 50

                # North
                hasExits = False
                for y in range(-2, 0):
                    tile = Coord(x=bomb["x"], y=bomb["y"] + y)
                    if self.hasExits(tile):
                        hasExits = True

                for y in range(-2, 0):
                    es = self.calcBombFields(es, bomb, 0, y, maxDanger, hasExits)

                # South
                hasExits = False
                for y in range(1, 3):
                    tile = Coord(x=bomb["x"], y=bomb["y"] + y)
                    if self.hasExits(tile):
                        hasExits = True

                for y in range(1, 3):
                    es = self.calcBombFields(es, bomb, 0, y, maxDanger, hasExits)

                # West
                hasExits = False
                for x in range(-2, 0):
                    tile = Coord(x=bomb["x"] + x, y=bomb["y"])
                    if self.hasExits(tile):
                        hasExits = True

                for x in range(-2, 0):
                    es = self.calcBombFields(es, bomb, x, 0, maxDanger, hasExits)

                # East
                hasExits = False
                for x in range(1, 3):
                    tile = Coord(x=bomb["x"] + x, y=bomb["y"])
                    if self.hasExits(tile):
                        hasExits = True

                for x in range(1, 3):
                    es = self.calcBombFields(es, bomb, x, 0, maxDanger, hasExits)

            for y in range(self.height):
                for x in range(self.width):
                    self.pf[y][x] -= es[y][x]

        if calcWalls:
            alltiles = [[Coord(x=x, y=y) for x in range(self.width)] for y in range(self.height)]

            for row in alltiles:
                for tile in row:
                    if not self.passableTile(tile):
                        self.pf[tile.y][tile.x] = -50

        for y in range(self.height):
            for x in range(self.width):
                modifier = 0
                if self.exitsAvailable(Coord(x=x, y=y)) == 0:
                    modifier = 10
                self.pf[y][x] = min(50, max(-50, self.pf[y][x])) - modifier

        for i, pos in enumerate(self.previousPositions):
            self.pf[pos.y][pos.x] -= 4 - i
       
        #self.debugwindow.setData(self.width, self.height, self.pf)

        #if not self.debugwindow.isRunning:
        #    self.debugwindow.start()