import sys
sys.path.append("..")
import random
import pprint
from coord import Coord
from connector import GameConnector
from pfworld import PFWorld
import time

class Bot(object):
    debug = False
    name = "zomgBot"
    gc = None
    ticksBeforeExplosion = 5
    roundsSinceBomb = 0
    updates = 0
    start = None
    mapData = PFWorld(Coord(x=4, y=4), ["++++", "+..+", "+..+", "++++"])

    def __init__(self, host = "localhost", port = 54321):
        self.gc = GameConnector(self.name)

        self.gc.handler_mapdata = self.mapUpdate
        self.gc.handler_ownposition = self.ownPosition
        self.gc.handler_enemylist = self.enemyList
        self.gc.handler_commandrequest = self.makeChoice
        self.gc.handler_bomblist = self.bombList
        self.gc.handler_endround = self.endOfRound
        self.gc.handler_dead = self.dead

        self.gc.connect(host, port)

        self.mapData.debug = self.debug

    def run(self):
        self.gc.parsingLoop()

    def dead(self):
        if self.debug:
            print "Got {0} updates in {1}".format(self.updates, time.time() - self.start)
        print "Oh no! I am dead!"

    def endOfRound(self):
        if self.debug:
            print "Got {0} updates in {1}".format(self.updates, time.time() - self.start)
        
    def bombList(self, bombs):
        if self.debug:
            print "Bombs: {0}".format(bombs)

        for bomb in bombs:
            self.ticksBeforeExplosion = max(self.ticksBeforeExplosion, bomb["state"])

        self.mapData.updateBombs(bombs)

    def newTarget(self):
        self.target = Coord(x=random.randint(1, self.mapData.width - 1), y=random.randint(1, self.mapData.height - 1))

    def makeChoice(self):
        if self.start == None:
            self.start = time.time()

        self.updates += 1
        self.mapData.calculatePotensialFields()

        if self.roundsSinceBomb < 0 and not self.mapData.deadlyWithin(self.ownPosition, 5):
            for enemy in self.mapData.enemies:
                if abs(enemy["x"] - self.ownPosition.x) + abs(enemy["y"] - self.ownPosition.y) < 2:
                    self.roundsSinceBomb = self.ticksBeforeExplosion
                    return "BOMB"

            for direction, offset in self.mapData.directions.iteritems():
                target = self.ownPosition + offset
                if self.mapData.isExplodable(target):
                    self.roundsSinceBomb = self.ticksBeforeExplosion
                    return "BOMB"

        else:
            self.roundsSinceBomb -= 1

        return self.mapData.getMoveFromPotensialFields(self.ownPosition)

    def enemyList(self, enemies):
        if self.debug:
            print "There are {0} enemies playing".format(len(enemies))
        self.mapData.updateEnemies(enemies)

    def ownPosition(self, ownPosition):
        if self.debug:
            print "I am at {0}".format(ownPosition)
        self.ownPosition = ownPosition
        # self.mapData.updateOwnPosition(ownPosition)

    def mapUpdate(self, mapSize, mapTiles):
        if self.debug:
            print "Map is {0}".format(mapSize)
        self.mapData.update(mapSize, mapTiles)


if __name__ == "__main__":
    if len(sys.argv) == 2:
        print "Connecting to {0}:54321".format(sys.argv[1])
        bot = Bot(sys.argv[1])
        bot.run()

    elif len(sys.argv) == 3:
        print "Connecting to {0}:{1}".format(sys.argv[1], sys.argv[2])
        bot = Bot(sys.argv[1], int(sys.argv[2]))
        bot.run()

    else:
        print "Connecting to localhost:54321"
        bot = Bot()
        bot.run()        