package com.petterroea.util;

import java.nio.ByteBuffer;

public class MathUtils {
	public static int min(int x, int y) {
		if(x<y) return x;
		return y;
	}
	public static int max(int x, int y){
		if(x>y) return x;
		return y;
	}
	public static boolean isInt(String str)
	{
		try{
			int i = Integer.parseInt(str);
		} catch(Exception e) {
			return false;
		}
		return true;
	}
	public static boolean isFloat(String sc) {
		try {
			float f = Float.parseFloat(sc);
		} catch(Exception e) {
			return false;
		}
		return true;
	}
	public static int average(int[] values)
	{
		if(values.length==0) throw new RuntimeException("Value list is empty!");
		int holder = 0;
		for(int i = 0; i < values.length; i++)
		{
			holder += values[i];
		}
		return holder/values.length;
	}
	public static float average(float[] values)
	{
		if(values.length==0) throw new RuntimeException("Value list is empty!");
		float holder = 0;
		for(int i = 0; i < values.length; i++)
		{
			holder += values[i];
		}
		return holder/(float)values.length;
	}
	public static double average(double[] values)
	{
		if(values.length==0) throw new RuntimeException("Value list is empty!");
		double holder = 0;
		for(int i = 0; i < values.length; i++)
		{
			holder += values[i];
		}
		return holder/(double)values.length;
	}
	public static long average(long[] values)
	{
		if(values.length==0) throw new RuntimeException("Value list is empty!");
		long holder = 0;
		for(int i = 0; i < values.length; i++)
		{
			holder += values[i];
		}
		return holder/(long)values.length;
	}
	public static short average(short[] values)
	{
		if(values.length==0) throw new RuntimeException("Value list is empty!");
		int holder = 0;
		for(int i = 0; i < values.length; i++)
		{
			holder += values[i];
		}
		return (short)(holder/values.length);
	}
	public static byte[] longToBytes(long x) {
	    ByteBuffer buffer = ByteBuffer.allocate(8);
	    buffer.putLong(x);
	    return buffer.array();
	}

	public static long bytesToLong(byte[] bytes) {
	    ByteBuffer buffer = ByteBuffer.allocate(8);
	    buffer.put(bytes);
	    buffer.flip();//need flip 
	    return buffer.getLong();
	}
	public int between(int value, int Min, int Max)
	{
		//Yeah, thats how it works.
		return min(max(value, Min), Max);
	}
}
