import ctypes

def _arraygen(type_):
	def arraygen(items):
		return (type_ * len(items))(*items)
	return arraygen

Float = ctypes.c_float
Floats = _arraygen(Float)
Int = ctypes.c_int
Ints = _arraygen(Int)
Char = ctypes.c_ubyte
Chars = _arraygen(Char)
Short = ctypes.c_ushort
Shorts = _arraygen(Short)
Str = ctypes.c_char_p
Ref = ctypes.byref
SIZEOF_FLOAT = ctypes.sizeof(Float)
SIZEOF_SHORT = ctypes.sizeof(Short)
