define(["three", "skySphere", "objects", "util", "random", "camera"], 
    function(THREE, skySphere, objects, util, random, camera) {
        var scene = new THREE.Scene();
        var numHats = 20;
        var hats;
        var velocityHats;

        var sceneTime = 0;

        scene.init = function() {
            var hemiLight = new THREE.HemisphereLight(0xFFFFFF, 0x666666, 0.8); 

            this.motherfuckerState = false;

            scene.add(hemiLight);
            scene.add(skySphere.clone());

            hats = new Array(numHats);
            velocityHats = new Array(numHats);
            for(var i = 0;i < numHats;++i)
            {
                var hat = objects.hat.clone();
                var randPos = util.randomVec3(new random(i*1000));
                hat.position.copy(randPos.multiplyScalar(100));
                scene.add(hat);
                hat.hasFoundPos = false;
                hats[i] = hat;
                velocityHats[i] = new THREE.Vector3(0,0,0); 
            }
        }

        scene.enter = function() {
            camera.reset();
            camera.position.z = 0;
            camera.position.y = -80;
            camera.rotation.x = 0.5*Math.PI;
            sceneTime = 0;
        }

        var numBarPerFuck = 4;

        scene.update = function(t, dt) {            
            var end = util.beatsToTime(130, {bars: 0, beats: 2, eights: 0});
            if(sceneTime < end)
            {                
                this.fadeAmount = (end - sceneTime) / end;
            }
            else
            {
                this.fadeAmount = 0;
            }

            sceneTime += dt;
            t *= 4;
            dt *= 4;            
            var radius = 40;
            var radPerHat = (2 * Math.PI) / hats.length;
            var heightPerHat = 5;

            if(camera.rotation.x > 0)
            {
                camera.rotation.x -= 0.1 * dt;
                camera.position.z += 10 * dt;
                camera.position.y += 5 * dt;
            }

            var timeForBeat = util.beatsToTime(130, {bars: 2, beats: 0, eights: 0});

            this.fadeAmount = (1.0 - ((sceneTime % timeForBeat) * 2)).clamp(0, 1);

            for(var i = 0;i < hats.length;++i)
            {                
                var newRadius = !this.motherfuckerState ? 
                    radius*Math.exp(-(hats.length-i)*3/hats.length) : 
                    radius*Math.sin(i);
                var hat = hats[i];                
                var finalPos = new THREE.Vector3(
                    Math.sin(radPerHat*i+t)*newRadius,
                    heightPerHat * i - 50,
                    Math.cos(radPerHat*i+t)*newRadius);

                /*var dist = hat.position.distanceTo(finalPos);
                if(!hat.hasFoundPos && dist >= 3)
                {
                    var oneOverDist = 1 / dist;
                    var toTarget = finalPos.sub(hat.position).clone();
                    toTarget = toTarget.multiplyScalar(oneOverDist);                    
                    velocityHats[i].add(toTarget.multiplyScalar(oneOverDist*500));
                    velocityHats[i].multiplyScalar(Math.pow(0.97, dt));                                
                    hat.position.add(velocityHats[i].multiplyScalar(dt));
                }
                else*/
                {
                    hat.hasFoundPos = true;
                    hat.position.copy(finalPos);
                    hat.position.y += Math.sin(t*2*Math.PI*0.4629)*5;
                }
            }
        }

        return scene;
    });