define(["three", "resources"], function(THREE, resources) {
    // Hat
    var hatGeometry = resources.getModel("hat");
    var hatMaterial = new THREE.MeshPhongMaterial({
        ambient: 0x333333, color: 0xaabbee, specular: 0x999999, shininess: 2
    });

    // Text plane (calligraphy)
    var textPlaneGeometry = new THREE.PlaneBufferGeometry(40, 40);
    var textPlaneMaterial = new THREE.MeshBasicMaterial({
        map: resources.getTexture('calligraphy'),
        transparent: true,
        side: THREE.DoubleSide
    });

    var nipplePlaneGeometry = new THREE.PlaneBufferGeometry(40, 40);
    var nippleMaterial = new THREE.MeshBasicMaterial({
        map: resources.getTexture('nipples'),
        transparent: true,
        side: THREE.DoubleSide
    });

    var introPlaneGeometry = new THREE.PlaneBufferGeometry(40, 40);
    var introMaterial = new THREE.MeshBasicMaterial({
        map: resources.getTexture('intro'),
        transparent: true,
        side: THREE.DoubleSide
    });

    var creditsPlaneGeometry = new THREE.PlaneBufferGeometry(40, 40);
    var creditsMaterial = new THREE.MeshBasicMaterial({
        map: resources.getTexture('credits'),
        transparent: true,
        side: THREE.DoubleSide
    });

    return {
        hat: new THREE.Mesh(hatGeometry, hatMaterial),
        textPlane: new THREE.Mesh(textPlaneGeometry, textPlaneMaterial),
        nipplePlane: new THREE.Mesh(nipplePlaneGeometry, nippleMaterial),
        introPlane: new THREE.Mesh(introPlaneGeometry, introMaterial),
        creditsPlane: new THREE.Mesh(creditsPlaneGeometry, creditsMaterial)
    };
});
