/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioEffect;
import java.util.HashSet;
import java.util.Vector;

public class EffectsChain
implements AudioEffect {
    private Vector<AudioEffect> effects = new Vector();
    private HashSet<AudioEffect> enabled = new HashSet();

    public synchronized void add(AudioEffect audioEffect) {
        this.effects.add(audioEffect);
        this.enabled.add(audioEffect);
    }

    public synchronized void remove(AudioEffect audioEffect) {
        this.effects.remove(audioEffect);
        this.enabled.remove(audioEffect);
    }

    public synchronized AudioEffect remove(int n) {
        AudioEffect audioEffect = this.effects.remove(n);
        this.enabled.remove(audioEffect);
        return audioEffect;
    }

    public synchronized AudioEffect get(int n) {
        return this.effects.get(n);
    }

    public synchronized boolean contains(AudioEffect audioEffect) {
        return this.effects.contains(audioEffect);
    }

    public synchronized void enable(int n) {
        this.enabled.add(this.get(n));
    }

    public synchronized void enable(AudioEffect audioEffect) {
        if (this.effects.contains(audioEffect)) {
            this.enabled.add(audioEffect);
        }
    }

    public synchronized void enableAll() {
        this.enabled.addAll(this.effects);
    }

    public synchronized boolean hasEnabled() {
        return this.enabled.size() > 0;
    }

    public synchronized boolean isEnabled(AudioEffect audioEffect) {
        return this.enabled.contains(audioEffect);
    }

    public synchronized void disable(int n) {
        this.enabled.remove(this.get(n));
    }

    public synchronized void disable(AudioEffect audioEffect) {
        this.enabled.remove(audioEffect);
    }

    public synchronized void disableAll() {
        this.enabled.clear();
    }

    public synchronized int size() {
        return this.effects.size();
    }

    public synchronized void clear() {
        this.effects.clear();
        this.enabled.clear();
    }

    @Override
    public synchronized void process(float[] fArray) {
        for (int i = 0; i < this.effects.size(); ++i) {
            AudioEffect audioEffect = this.effects.get(i);
            if (!this.enabled.contains(audioEffect)) continue;
            audioEffect.process(fArray);
        }
    }

    @Override
    public synchronized void process(float[] fArray, float[] fArray2) {
        for (int i = 0; i < this.effects.size(); ++i) {
            AudioEffect audioEffect = this.effects.get(i);
            if (!this.enabled.contains(audioEffect)) continue;
            audioEffect.process(fArray, fArray2);
        }
    }
}

