/*
 * Decompiled with CFR 0.152.
 */
package toxi.util.datatypes;

import java.util.ArrayList;
import java.util.List;
import toxi.math.MathUtils;
import toxi.util.datatypes.WeightedRandomEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedRandomSet<T> {
    protected List<WeightedRandomEntry<T>> elements = new ArrayList<WeightedRandomEntry<T>>();
    protected int totalWeight;

    public WeightedRandomSet<T> add(T t, int n) {
        WeightedRandomEntry<T> weightedRandomEntry = new WeightedRandomEntry<T>(t, n);
        int n2 = this.elements.size();
        boolean bl = false;
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                if (n >= this.elements.get((int)i).weight) continue;
                this.elements.add(i, weightedRandomEntry);
                bl = true;
                break;
            }
        }
        if (!bl) {
            this.elements.add(weightedRandomEntry);
        }
        this.totalWeight += n;
        return this;
    }

    public List<WeightedRandomEntry<T>> getElements() {
        return this.elements;
    }

    public T getRandom() {
        int n = MathUtils.random(this.totalWeight);
        T t = null;
        int n2 = this.totalWeight;
        for (WeightedRandomEntry<T> weightedRandomEntry : this.elements) {
            if ((n2 -= weightedRandomEntry.weight) > n) continue;
            t = weightedRandomEntry.item;
            break;
        }
        return t;
    }

    public void remove(T t) {
        for (WeightedRandomEntry<T> weightedRandomEntry : this.elements) {
            if (!weightedRandomEntry.item.equals(t)) continue;
            this.elements.remove(weightedRandomEntry);
            this.totalWeight -= weightedRandomEntry.weight;
            return;
        }
    }
}

