/*
 * Decompiled with CFR 0.152.
 */
package toxi.util.datatypes;

import java.util.Random;
import toxi.math.MathUtils;

public class IntegerSet {
    public int[] items;
    public int currID = -1;
    public int current;
    private Random random = new Random();

    public IntegerSet(int[] nArray) {
        this.items = nArray;
        this.pickRandom();
    }

    public IntegerSet(Integer ... integerArray) {
        if (integerArray.length > 0) {
            this.items = new int[integerArray.length];
            for (int i = 0; i < integerArray.length; ++i) {
                this.items[i] = integerArray[i];
            }
        } else {
            throw new IllegalArgumentException("can't create empty IntegerSet");
        }
        this.pickRandom();
    }

    public boolean contains(int n) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != n) continue;
            return true;
        }
        return false;
    }

    public int getCurrent() {
        return this.current;
    }

    public int pickRandom() {
        this.currID = MathUtils.random(this.random, this.items.length);
        this.current = this.items[this.currID];
        return this.current;
    }

    public int pickRandomUnique() {
        if (this.items.length > 1) {
            int n = this.currID;
            while (n == this.currID) {
                n = MathUtils.random(this.random, this.items.length);
            }
            this.currID = n;
        } else {
            this.currID = 0;
        }
        this.current = this.items[this.currID];
        return this.current;
    }

    public IntegerSet seed(long l) {
        this.random.setSeed(l);
        return this;
    }

    public void setRandom(Random random) {
        this.random = random;
    }
}

