/*
 * Decompiled with CFR 0.152.
 */
package toxi.util.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtil {
    public static <T> void addArrayToCollection(T[] TArray, Collection<T> collection) {
        if (collection == null) {
            collection = new ArrayList<T>();
        }
        for (T t : TArray) {
            collection.add(t);
        }
    }

    public static <T> ArrayList<T> arrayToList(T[] TArray) {
        ArrayList<T> arrayList = new ArrayList<T>(TArray.length);
        for (T t : TArray) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public static float[] getAsNormalizedFloatArray(int[] nArray, int n, int n2, int n3, float f) {
        float f2 = f / (float)n3;
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            if (n > 0) {
                n4 >>= n;
            }
            fArray[i] = (float)(n4 &= n2) * f2;
        }
        return fArray;
    }

    public static int indexInArray(float f, float[] fArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (fArray[i] != f) continue;
            return i;
        }
        return -1;
    }

    public static int indexInArray(int n, int[] nArray, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static float[] normalizeFloatArray(float[] fArray, float f, float f2) {
        float f3 = f2 / f;
        int n = 0;
        while (n < fArray.length) {
            int n2 = n++;
            fArray[n2] = fArray[n2] * f3;
        }
        return fArray;
    }

    public static void reverse(byte[] byArray) {
        int n = byArray.length - 1;
        int n2 = byArray.length / 2;
        for (int i = 0; i < n2; ++i) {
            byte by = byArray[i];
            byArray[i] = byArray[n - i];
            byArray[n - i] = by;
        }
    }

    public static void reverse(char[] cArray) {
        int n = cArray.length - 1;
        int n2 = cArray.length / 2;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            cArray[i] = cArray[n - i];
            cArray[n - i] = c;
        }
    }

    public static void reverse(float[] fArray) {
        int n = fArray.length - 1;
        int n2 = fArray.length / 2;
        for (int i = 0; i < n2; ++i) {
            float f = fArray[i];
            fArray[i] = fArray[n - i];
            fArray[n - i] = f;
        }
    }

    public static void reverse(int[] nArray) {
        int n = nArray.length - 1;
        int n2 = nArray.length / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            nArray[i] = nArray[n - i];
            nArray[n - i] = n3;
        }
    }

    public static void reverse(short[] sArray) {
        int n = sArray.length - 1;
        int n2 = sArray.length / 2;
        for (int i = 0; i < n2; ++i) {
            short s = sArray[i];
            sArray[i] = sArray[n - i];
            sArray[n - i] = s;
        }
    }

    public static <T> void reverse(T[] TArray) {
        int n = TArray.length - 1;
        int n2 = TArray.length / 2;
        for (int i = 0; i < n2; ++i) {
            T t = TArray[i];
            TArray[i] = TArray[n - i];
            TArray[n - i] = t;
        }
    }

    public static <T> void shuffle(T[] TArray) {
        ArrayUtil.shuffle(TArray, new Random());
    }

    public static <T> void shuffle(T[] TArray, Random random) {
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i + random.nextInt(n - i);
            T t = TArray[i];
            TArray[i] = TArray[n2];
            TArray[n2] = t;
        }
    }
}

