/*
 * Decompiled with CFR 0.152.
 */
package toxi.util;

import java.io.File;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSequenceDescriptor
implements Iterable<String> {
    public String filePattern;
    public String extension;
    public int numDigits;
    public int start;
    public int end = -1;

    public FileSequenceDescriptor(String string, String string2, int n, int n2) {
        this.filePattern = string;
        this.extension = string2;
        this.numDigits = n;
        this.start = n2;
    }

    public String getBasePath() {
        return this.filePattern.substring(0, this.filePattern.indexOf(37));
    }

    public int getDuration() {
        return this.getFinalIndex() - this.start;
    }

    public int getFinalIndex() {
        if (this.end == -1) {
            this.end = this.start;
            while (new File(this.getPathForIndex(this.end)).canRead()) {
                ++this.end;
            }
        }
        return this.end;
    }

    public String getPathForIndex(int n) {
        return String.format(this.filePattern, n);
    }

    public int getStartIndex() {
        return this.start;
    }

    @Override
    public Iterator<String> iterator() {
        return new SequenceIterator(this.start, this.getFinalIndex());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SequenceIterator
    implements Iterator<String> {
        private int curr;
        private int end;

        public SequenceIterator(int n, int n2) {
            this.curr = n;
            this.end = n2;
        }

        @Override
        public boolean hasNext() {
            return this.curr < this.end;
        }

        @Override
        public String next() {
            String string = FileSequenceDescriptor.this.getPathForIndex(this.curr);
            ++this.curr;
            return string;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }
    }
}

