/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import toxi.geom.Circle;
import toxi.geom.Intersector2D;
import toxi.geom.IsectData2D;
import toxi.geom.Ray2D;
import toxi.geom.Vec2D;

public class CircleIntersector
implements Intersector2D {
    private IsectData2D isec;
    private Circle circle;

    public CircleIntersector(Circle circle) {
        this.circle = circle;
    }

    public IsectData2D getIntersectionData() {
        return this.isec;
    }

    public boolean intersectsRay(Ray2D ray2D) {
        this.isec.clear();
        Vec2D vec2D = this.circle.sub(ray2D);
        float f = vec2D.magSquared();
        float f2 = vec2D.dot(ray2D.getDirection());
        float f3 = this.circle.getRadius();
        float f4 = f3 * f3 - (f - f2 * f2);
        if ((double)f4 >= 0.0) {
            this.isec.isIntersection = true;
            this.isec.dist = f2 - (float)Math.sqrt(f4);
            this.isec.pos = ray2D.getPointAtDistance(this.isec.dist);
            this.isec.normal = this.isec.pos.sub(this.circle).normalize();
        }
        return this.isec.isIntersection;
    }
}

