/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import ddf.minim.MultiChannelBuffer;
import ddf.minim.analysis.BeatDetect;
import ddf.minim.analysis.FFT;
import java.util.Arrays;
import processing.core.PApplet;
import processing.core.PShape;
import toxi.geom.Vec3D;

public class demo
extends PApplet {
    int CANVAS_WIDTH = 1920;
    int CANVAS_HEIGHT = 1080;
    int SONG_SKIP_MILLISECONDS = 2000;
    String SONG_FILE = "Freaky_-_For_a_Better_Days.wav";
    int FFT_BUFFER_SIZE = 1024;
    int FFT_WINDOW_SIZE = 2048;
    int GRID_SIZE = 5;
    int GRID_DISTANCE = 450;
    float TIME_GREETS_START = 22.5f;
    float TIME_GREETS_STOP = 40.0f;
    float TIME_INFO_STOP = 10.0f;
    float cameraPosMark1 = 0.0f;
    float cameraTimeMark1 = 0.0f;
    float WORM_BEGIN_TIME = 40.0f;
    float WORM_BEGIN_ROTATIONS_TIME = 45.0f;
    float DEMO_END_TIME = 103.2f;
    BallGrid fractal;
    Worm worm;
    AudioManager audioManager;

    public void setup() {
        demo.println((String)"setup start");
        this.size(this.displayWidth, this.displayHeight, "processing.opengl.PGraphics3D");
        this.rectMode(3);
        this.frameRate(30.0f);
        this.smooth();
        this.audioManager = new AudioManager(this, this.SONG_FILE, this.FFT_BUFFER_SIZE, this.FFT_WINDOW_SIZE);
        this.fractal = new BallGrid(this, this.audioManager);
        this.worm = new Worm(this, 0.0f, 0.0f, 0.0f);
        this.audioManager.play();
        demo.println((String)"setup end");
    }

    public void draw() {
        this.audioManager.update();
        this.resetMatrix();
        this.background(255);
        this.drawDemo(this.audioManager.currentTimeSeconds());
    }

    public void keyPressed() {
        if (this.key == '\uffff') {
            if (this.keyCode == 37) {
                this.audioManager.skip(-this.SONG_SKIP_MILLISECONDS);
            } else if (this.keyCode == 39) {
                this.audioManager.skip(this.SONG_SKIP_MILLISECONDS);
            }
        } else if (this.key == ' ') {
            if (this.audioManager.isPlaying()) {
                this.audioManager.pause();
            } else {
                this.audioManager.play();
            }
        }
    }

    public void setCameraPosition(float f) {
        Vec3D vec3D = new Vec3D(0.0f, 0.0f, 0.0f);
        Vec3D vec3D2 = new Vec3D(0.0f, 0.0f, 0.0f);
        Vec3D vec3D3 = new Vec3D(0.0f, 1.0f, 0.0f);
        if (f < this.TIME_GREETS_START) {
            vec3D.z = -2000.0f + demo.cos((float)(f * 0.3f)) * -1000.0f;
            vec3D.rotateY(demo.sin((float)(f * 0.3f)) * (float)Math.PI / 2.0f);
        } else if (f < this.TIME_GREETS_STOP) {
            vec3D.z = 2500.0f;
            vec3D.x = (float)this.GRID_DISTANCE * demo.cos((float)f);
            vec3D.y = (float)this.GRID_DISTANCE * demo.sin((float)f);
            vec3D.rotateY(demo.sin((float)(f - this.TIME_GREETS_START)) * 0.5f);
        } else if (f < this.WORM_BEGIN_ROTATIONS_TIME) {
            vec3D.z = 2500.0f;
        } else if (f < this.DEMO_END_TIME) {
            float f2 = f - this.WORM_BEGIN_ROTATIONS_TIME;
            vec3D.z = 2500.0f;
            vec3D.x = (float)this.GRID_DISTANCE * demo.sin((float)f2);
            vec3D.y = (float)this.GRID_DISTANCE * -demo.sin((float)f2);
            vec3D.rotateX(demo.sin((float)(f2 * 0.3f)) * (float)Math.PI / 2.0f);
            vec3D.rotateY(-demo.sin((float)(f2 * 0.2f)) * (float)Math.PI / 2.0f);
            vec3D.rotateZ(demo.sin((float)(f2 * 0.1f)) * (float)Math.PI / 2.0f);
        }
        this.beginCamera();
        this.camera(vec3D.x, vec3D.y, vec3D.z, vec3D2.x, vec3D2.y, vec3D2.z, vec3D3.x, vec3D3.y, vec3D3.z);
        this.endCamera();
    }

    public void drawBackground() {
        this.background(0);
    }

    public void drawDemo(float f) {
        demo.println((Object[])new Object[]{"TIME: ", Float.valueOf(f)});
        this.setCameraPosition(f);
        this.drawBackground();
        if (f > this.DEMO_END_TIME) {
            this.audioManager.pause();
        }
        if (f < this.TIME_INFO_STOP) {
            this.pushMatrix();
            this.rotateY((float)Math.PI + demo.sin((float)f) * 0.7f);
            this.fill(255);
            this.textSize(40.0f);
            this.textAlign(3);
            this.text("Graffathon 2014", 0.0f, -60.0f, 0.0f);
            this.text("CubeGrid", 0.0f, 0.0f, 0.0f);
            this.text("By BJAKKE", 0.0f, 60.0f, 0.0f);
            this.popMatrix();
        }
        if (f > this.TIME_GREETS_START && f < this.TIME_GREETS_STOP) {
            this.fill(255);
            this.textSize(60.0f);
            this.textAlign(3);
            this.text("GREETINGS TO EVERYONE!", 200.0f * demo.sin((float)(f * 0.5f)), demo.cos((float)(f * 0.9f)) * 300.0f, 0.0f);
        }
        this.fractal.draw(this.GRID_SIZE, this.GRID_SIZE, this.GRID_SIZE, this.GRID_DISTANCE);
        if (f >= this.WORM_BEGIN_TIME) {
            this.pushMatrix();
            this.translate(this.GRID_DISTANCE / 2, this.GRID_DISTANCE / 2, 0.0f);
            this.worm.setStartTime(f);
            this.worm.draw(f);
            this.popMatrix();
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--hide-stop", "demo"};
        if (stringArray != null) {
            PApplet.main((String[])demo.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class AudioManager {
        PApplet applet;
        Minim minim;
        AudioPlayer audioplayer;
        MultiChannelBuffer buffers;
        float[] sampledata;
        FFT fft;
        int bufsize;
        int windowsize;
        int rate;
        BeatDetect bdetect;

        AudioManager(PApplet pApplet, String string, int n, int n2) {
            this.applet = pApplet;
            this.bufsize = n;
            this.windowsize = n2;
            this.minim = new Minim((Object)this.applet);
            this.audioplayer = this.minim.loadFile(string, this.bufsize);
            this.buffers = new MultiChannelBuffer(2, 2);
            this.rate = (int)this.audioplayer.sampleRate();
            this.minim.loadFileIntoBuffer(string, this.buffers);
            this.sampledata = this.buffers.getChannel(0);
            this.fft = new FFT(this.windowsize, (float)this.rate);
            this.fft.window(FFT.HAMMING);
            this.bdetect = new BeatDetect(this.windowsize, (float)this.rate);
            this.bdetect.detectMode(0);
        }

        public float currentTimeSeconds() {
            return (float)this.audioplayer.position() / 1000.0f;
        }

        public void play() {
            this.audioplayer.play();
        }

        public void pause() {
            this.audioplayer.pause();
        }

        public boolean isPlaying() {
            return this.audioplayer.isPlaying();
        }

        public void update() {
            this.analyze();
        }

        public float analyzeRange(int n, int n2) {
            float f = 0.0f;
            int n3 = n;
            while (n3 <= n2) {
                f += this.fft.getBand(n3);
                ++n3;
            }
            return f / ((float)(n2 - n) + 1.0f);
        }

        public BeatDetect beatDetector() {
            return this.bdetect;
        }

        public void analyze() {
            int n = this.player_samplepos();
            float[] fArray = Arrays.copyOfRange(this.sampledata, n, n + this.windowsize);
            this.fft.forward(fArray);
            this.bdetect.detect(fArray);
        }

        public int player_samplepos() {
            float f = (float)this.audioplayer.position() / 1000.0f;
            int n = (int)(f * this.audioplayer.sampleRate());
            n -= this.windowsize / 2;
            n = demo.max((int)n, (int)0);
            n = demo.min((int)n, (int)(this.sampledata.length - this.windowsize));
            return n;
        }

        public void skip(int n) {
            this.audioplayer.skip(n);
        }
    }

    class BallGrid {
        PApplet applet;
        PShape shape;
        PShape trigger_shape;
        AudioManager audioManager;
        int FFT_RANGE_BEGIN = 1;
        int FFT_RANGE_END = 1;
        int FFT_TRIGGER = 20;
        int FFT_ROTATE_RANGE_BEGIN = 92;
        int FFT_ROTATE_RANGE_END = 98;
        float fade = 0.0f;

        BallGrid(PApplet pApplet, AudioManager audioManager) {
            this.applet = pApplet;
            this.audioManager = audioManager;
            this.shape = demo.this.createShape(41, new float[]{35.0f});
            this.shape.setFill(demo.this.color(200, 0, 255));
            this.shape.setStroke(demo.this.color(255, 255, 255));
            this.shape.setStrokeWeight(1.0f);
            this.trigger_shape = demo.this.createShape(40, new float[]{25.0f});
            this.trigger_shape.setFill(demo.this.color(200, 0, 255));
            this.trigger_shape.setStroke(demo.this.color(255, 255, 255));
            this.trigger_shape.setStrokeWeight(1.0f);
        }

        public void draw(int n, int n2, int n3, float f) {
            float f2 = this.audioManager.analyzeRange(this.FFT_RANGE_BEGIN, this.FFT_RANGE_END);
            if (f2 > 20.0f) {
                demo.println((Object[])new Object[]{"BEAT", Float.valueOf(f2), "NOW"});
                this.fade = 1.0f;
            } else {
                this.fade *= 0.9f;
                demo.println((Object[])new Object[]{"BEAT", Float.valueOf(f2)});
            }
            demo.this.pushMatrix();
            demo.this.translate(demo.this.GRID_DISTANCE / 2, demo.this.GRID_DISTANCE / 2, demo.this.GRID_DISTANCE / 2);
            PShape pShape = demo.this.createShape(this.shape);
            pShape.scale(this.fade);
            int n4 = -n3;
            while (n4 < n3) {
                int n5 = -n2;
                while (n5 < n2) {
                    int n6 = -n;
                    while (n6 < n) {
                        demo.this.pushMatrix();
                        demo.this.translate((float)n6 * f, (float)n5 * f, (float)n4 * f);
                        this.triggerShape(pShape);
                        demo.this.popMatrix();
                        ++n6;
                    }
                    ++n5;
                }
                ++n4;
            }
            demo.this.popMatrix();
        }

        public void triggerShape(PShape pShape) {
            demo.this.rotateX(this.audioManager.currentTimeSeconds() * 1.5f);
            demo.this.rotateZ(demo.sin((float)this.audioManager.currentTimeSeconds()));
            demo.this.shape(pShape);
        }
    }

    class Worm {
        PApplet applet;
        Vec3D pos;
        PShape shape;
        float startTime = 0.0f;

        Worm(PApplet pApplet, float f, float f2, float f3) {
            this.applet = pApplet;
            this.pos = new Vec3D(f, f2, f3);
            this.shape = demo.this.createShape(40, new float[]{5.0f});
            this.shape.setFill(demo.this.color(255, 255, 255));
            this.shape.setStroke(demo.this.color(0, 255, 255));
            this.shape.setStrokeWeight(1.0f);
        }

        public void setStartTime(float f) {
            if (this.startTime < 1.0f) {
                this.startTime = f;
            }
        }

        public void drawInternal() {
            demo.this.shape(this.shape);
        }

        public void draw(float f) {
            demo.this.pushMatrix();
            demo.this.translate(this.pos.x, this.pos.y, this.pos.z);
            this.drawInternal();
            float f2 = 0.1f;
            float f3 = this.startTime;
            while (f3 < f) {
                demo.this.translate(20.0f, 50.0f, 80.0f * demo.sin((float)f3));
                demo.this.rotateX(f3 * 5.0f);
                demo.this.rotateY(f3 * 4.0f);
                demo.this.rotateZ(demo.sin((float)f3) * 1.0f);
                this.drawInternal();
                f3 += f2;
            }
            demo.this.popMatrix();
        }
    }
}

