uniform mat4 mvp;
uniform vec4 instance_positions[50];
uniform vec4 instance_parameters[50];
uniform float aspect_ratio;

attribute vec3 in_position;
attribute vec2 in_texcoord;

varying vec2 out_texcoord;
varying vec4 out_color;
varying vec3 out_normal;
varying vec3 out_pos;


void main()
{
	float lineWidth = instance_positions[int(in_position.y)].w * 8.0;
	
	vec3 a = instance_positions[int(in_position.y)].xyz;
	vec3 b = instance_positions[int(in_position.z)].xyz;
	
	vec4 a0 = mvp * vec4( a, 1.0);
	vec4 b0 = mvp * vec4( b, 1.0);
	vec2 Delta = normalize( b0.xy / b0.w - a0.xy / a0.w);
	
	a0.x += in_position.x * -Delta.y * aspect_ratio * lineWidth;
	a0.y += in_position.x * Delta.x * lineWidth;

	gl_Position = a0;
	out_texcoord = in_texcoord;
	out_color = instance_parameters[int(in_position.y)];
}
