varying vec2 out_texcoord;
varying float cloud_height;

uniform sampler2D color_map;
uniform float ldr_scale;
uniform vec2 hdr_params;
uniform float time;


void main()
{   
#ifdef HDR
	vec3 color = RGBEtoRGB( texture2D( color_map, out_texcoord));
#else
	vec3 color = texture2D( color_map, out_texcoord).xyz;
	color *= color;
#endif

#ifdef DYNAMIC_CLOUDS
	vec2 tc0 = out_texcoord * vec2( 1.1, 1.1) + vec2( time * 0.01, 0.0);
	vec3 color0 = texture2D( color_map, tc0).xyz;

	vec2 tc1 = out_texcoord * vec2( 1.2, 1.2) + vec2( time * 0.01, 0.0);
	vec3 color1 = texture2D( color_map, tc1).xyz;

	vec2 tc2 = out_texcoord * vec2( 2.4, 2.4) + vec2( time * 0.01, 0.0);
	vec3 color2 = texture2D( color_map, tc2).xyz;

	vec2 tc3 = out_texcoord * vec2( 4.5, 4.5) + vec2( time * 0.01, 0.0);
	vec3 color3 = texture2D( color_map, tc3).xyz;
	
	color = color0 + color1 + color2 + color3;
	
	color -= vec3( 2.0);

	float l = clamp( color.x, 0.0, 1.0) * cloud_height;
	
	color = mix( vec3( 1.25293, 1.37012, 1.70215), vec3( 6.0, 6.24, 5.94), l);
	color = mix( vec3( 0.25293, 0.37012, 0.70215), color, cloud_height);
#endif

	color *= vec3(ldr_scale);

	expose( color, hdr_params.x, hdr_params.y);
	
	float max_luminance = dot(vec3(0.30, 0.59, 0.11), color);
	max_luminance -= 1.0;
	// max_luminance -= 0.5;

	gl_FragColor = vec4( color, max_luminance);
}

