#ifndef RGBE_EMAX
#define RGBE_EMAX 255.0
#endif

#ifndef ENVMMAP_MAX_LOD
#define ENVMMAP_MAX_LOD 10.0
#endif

#ifndef SPECULAR_MAX_ROUGHNESS
#define SPECULAR_MAX_ROUGHNESS 1024.0
#endif

void gamma( inout vec3 c)
{
	const float gamma = 0.5;
//	c = pow( c, vec3( 1.0 / gamma));
}

void expose3( inout vec3 x, float exposure);

void expose( inout vec3 color, float exposure, float brightness)
{
#if 1
	float Y = exposure * ( ( exposure / brightness + 64.0) / ( exposure +  64.0) );
	color *= exposure;
#else
	expose3( color, exposure);
#endif
}


void expose2( inout vec3 x, float exposure)
{
//	float L = dot(vec3(0.30, 0.59, 0.11), color);
//	float Y = L / (exposure);
//	color *= Y;

	float A = 0.15;
	float B = 0.50;
	float C = 0.10;
	float D = 0.20;
	float E = 0.02;
	float F = 0.30;

	x *= exposure;
	x = ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}


void expose3( inout vec3 x, float exposure)
{
	x *= exposure;
	x = (x*(6.2*x+0.5))/(x*(6.2*x+1.7)+0.06);
	// x = pow( x, vec3( 2.2));
}


vec3 RGBEtoRGB( vec4 rgbe) 
{ 
	//return rgbe.rgb / rgbe.a;
	float e = rgbe.a * 255.0 - 128.0;
	e = exp2( e);
	return rgbe.rgb * vec3( e);
}


vec3 fetch_cube( vec4 cube[6], vec3 normal)
{	
	vec3 result;
	vec3 normal2 = normal * normal;

	result = ((normal.x < 0.0) ? cube[1].xyz : cube[0].xyz) * normal2.x;
	result += ((normal.y < 0.0) ? cube[3].xyz : cube[2].xyz) * normal2.y;
	result += ((normal.z < 0.0) ? cube[5].xyz : cube[4].xyz) * normal2.z;
		
	return result;
}


vec3 fetch_cubemap( samplerCube env, vec3 normal, float roughness)
{
#ifdef RGBE
	 // return RGBEtoRGB( textureCube( env, normal));
	 return RGBEtoRGB( textureCube( env, normal, roughness * 8.0));
#else
	 return textureCubeLod( env, normal, roughness * 8.0).xyz;
#endif	
}


float fetch_specular_intensity( vec3 dir, vec3 normal, float roughness)
{
	roughness = 1.0 - roughness;
	float s = clamp( dot( normal, dir), 0.0, 1.0);
	s = pow( s, roughness * SPECULAR_MAX_ROUGHNESS) * roughness * 16.0;
	return s;
}
