#Include "fbgfx.bi"
#Include "bass.bi"

Using fb

Declare Sub InitStars
Declare Sub DrawStars (counter As Integer)
Declare Sub PrepHeader
Declare Sub DrawHeader (counter As Integer)
Declare Sub WriteBuffers
Declare Sub DrawStrings (counter As Integer, x_pos1 As Integer, x_pos2 As integer)
Declare Sub DrawBars (counter As Integer)
Declare Sub SetCounters
Declare Sub Draw3DCube (counter As Integer)
Declare Sub InitMusic
Declare Sub DrawVUMeters

Randomize timer

'
Const	starnum = 2048
Const screen_x = 640, screen_y = 480, depth = 32, pages = 2, scale_ratio = screen_x\320, char_y = 8
Const xcenter = screen_x / 2 
Const ycenter = screen_y / 2
Dim shared SOUND_FILE As String
SOUND_FILE = "module.xm"
ScreenRes screen_x, screen_y, depth, pages, gfx_alpha_primitives Or gfx_high_priority
Print "loading..."

#Include "albom_font.bi"
#Include "wireframe.bas"
' 

Type _star
	x(starnum) As Single
	y(starnum) As Single
	z(starnum) As Single
	d As Integer = 256
End Type
Dim Shared star As _star

Type _counter
	main As Integer
	string1 As Integer = screen_x
	string2 As Integer = screen_x
End Type
Dim shared counter As _counter

Type _text
	string1 As String
	string2 As String
End Type
Dim Shared text As _text
#Include "strings.bas"

Dim Shared head As Any Ptr
Dim Shared As HMUSIC h: Dim As Integer flag,amplify=256,fade

head = ImageCreate(512,128,,32)

InitStars
InitMusic
PrepHeader
sincos_
cube_fill_ cube_p()

Do
	SetCounters
	counter.main +=1
	
	ScreenLock
	Line (0,0)-(screen_x,screen_y),RGB(0,0,0),bf ' CLS
	DrawStars counter.main
	DrawStrings counter.main, counter.string1, counter.string2
	Draw3DCube counter.main
	DrawBars counter.main
	DrawHeader counter.main
	DrawVUMeters
	ScreenUnLock
	
	If (MultiKey(fb.sc_alt) And MultiKey(fb.sc_f4)) Or (InKey = Chr(255) + "k") Then flag = 1
	If flag = 1 Then 
		BASS_ChannelSetAttribute h, BASS_ATTRIB_VOL, Cast(Single,amplify/256)
		Line (0,0)-(screen_x,screen_y), RGBA(0,0,0,fade), bf
		amplify -=1: fade +=1
	EndIf
	
	Sleep 2
	ScreenSync
	Screen , 0, 1
	ScreenCopy 0, 1
Loop Until amplify <=0

Sub InitStars
	For i As Integer = 1 To starnum
		star.x(i) = CInt(Rnd * screen_x)
		star.y(i) = -ycenter + CInt(Rnd * screen_y*2)
		star.z(i) = 48 + CInt(Rnd * 208)
	Next
End Sub

Sub DrawStars (counter As Integer)
	Dim As Integer i, xs, ys, col
	Line (0,0)-(screen_x,screen_y),RGB(0,0,0),bf ' CLS
	For i = 1 To starnum
		star.x(i) = star.x(i) + star.d/star.z(i)
		star.y(i) = star.y(i) + (star.d/star.z(i) * (0.5*sin(counter*.01)))
		xs = star.x(i)
		ys = star.y(i)' + (screen_y/4 * Sin(counter * .015))
		col = cint(-star.z(i)+256) 
		PSet (xs,ys), RGB(col,col,col)
		
		If star.x(i) >= screen_x Then 
			star.x(i) = 0
			star.y(i) = -ycenter + CInt(Rnd * screen_y*2)
			star.z(i) = 48 + CInt(Rnd * 208)
		EndIf	
	next
End Sub

Sub DrawStrings(counter As Integer, x_pos1 As Integer, x_pos2 As integer)
	Dim As Integer position
	Dim As String tempchar
	'drawing string1 (sinus scroller on bottom of screen)
	For position = -(x_pos1 - screen_x) \ 8 - (Screen_x/8) To -(x_pos1 - screen_x) \ 8
		tempchar = Mid(text.string1,position,1)
		Draw String ((x_pos1 + position * 8), _
		(12*scale_ratio)*Sin(0.027*(counter+(position*2)))+((Screen_y-((12*scale_ratio)+Char_y)))), tempchar
	Next
End Sub

Sub PrepHeader
	head = ImageCreate(512,96)
	BLoad "header.bmp", head
End Sub

Sub DrawHeader (counter As Integer)
	
	For y As integer = 0 To 127
		Put (((Screen_x - 512) / 2) + 8 * Sin((counter+y)*0.03),y+(20*scale_ratio)),_
		head,(0, y)-(512, y),alpha
	Next
End Sub

Sub DrawBars (counter As Integer)
	Const numofbars = 16
	Dim As Integer y(numofbars), i, j
	For i = 0 TO numofbars - 1
		  y(i) = Screen_y/2 * SIN((counter + (i * 3)) * .03) + Screen_y/2
	Next
	For i = 0 TO numofbars - 1
		Line (0,y(i)+j)-(Screen_x-1,y(i)+j),RGBA(64*cos((counter+i)*.04)+128,64*cos((counter+i)*.03)+128,64*cos((counter+i)*.02)+128,i*16)
	Next
End Sub

Sub SetCounters
	With counter
		.string1 -= 3
		.string2 -= 1
		If .string1 < -(Len(text.string1)*8) Then .string1 = screen_x
		If .string2 < -(Len(text.string2)*8) Then .string2 = screen_x
	End With
End Sub

Sub Draw3DCube (counter As Integer)
	For i As Integer = 1 To 4
		rotate_ (counter+i) Mod 512, (counter+i) Mod 512,(counter+i) Mod 512, cube_p(), cube_pt()
		p2d_ cube_pt(), cube_p2()
		cube_draw_ RGBA(64*Sin((counter+i)*.04)+128,64*Sin((counter+i)*.03)+128,64*Sin((counter+i)*.02)+128,i*(64\i)), cube_p2()
	Next	
End Sub

Sub InitMusic
	BASS_Init(-1, 44100, 0, 0, 0)
	h = BASS_MusicLoad(FALSE, SOUND_FILE, 0, 0, BASS_MUSIC_LOOP Or BASS_MUSIC_RAMPS, 0)
	BASS_ChannelPlay(h, FALSE)
End Sub

Sub DrawVUMeters
	Dim As Integer volume, volume_l, volume_r, fft_t(512)
	Dim As Single fft(512)
	volume = BASS_ChannelGetLevel(h)
	'Draw String backbuf.vumeters,(0,0), Str(LoWord(volume))
	Line (0,0)-(4*SCALE_RATIO,Sqr(LoWord(volume) Shr 5)*4), RGB(0,255,0), bf 
	Line (screen_x,0)-(screen_x-4*SCALE_RATIO,sqr(HiWord(volume) Shr 5)*4), RGB(0,255,0), bf
	BASS_ChannelGetData(h, @fft(0), BASS_DATA_FFT1024)
	For i As Integer = 1 To 128
		fft_t(i) = cint(Sqr(fft(i)*4096)*4)
		Line (64+(i*4),screen_y)-(64+(i*4+2),screen_y-fft_t(i)),  RGBA(0,255,0,64), bf 
	Next
End Sub