//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

using System.IO;
using System.Dynamic;
using System.Text.RegularExpressions;
using System;

namespace Framefield.Core.IDa54ed3a1_4d3e_47ef_b8fe_b4aeec9d0972
{
    public class Class_SkypeChatLogFiles : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            RefreshTrigger = 0,
            FileSizeMin = 1,
            FileSizeMax = 2
        }
        //<<< _inputids

        //>>> _outputids
        private enum OutputId
        {
            Dynamic = 0,
            Count = 1
        }
        //<<< _outputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var RefreshTrigger = inputs[(int)InputId.RefreshTrigger].Eval(context).Value;
            var FileSizeMin = inputs[(int)InputId.FileSizeMin].Eval(context).Value;
            var FileSizeMax = inputs[(int)InputId.FileSizeMax].Eval(context).Value;
            var FileSize = new Vector2(FileSizeMin, FileSizeMax);
            //<<< _params

            if (_allFiles == null || RefreshTrigger > 0.5f) 
            {
                _minFileSize = (int)FileSizeMin;
                _maxFileSize = (int)FileSizeMax;
                
                var directories = new List<String>() {
                    Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) + "\\Skype\\",
                    Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData) + "\\Skype\\",
                    Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData) + "\\Skype\\"
                };

                _allFiles = new List<String>();
                _allFiles.Clear();

                foreach (var path in directories)
                {
                    ScanDirectory(path);
                }
                
                Random rng = new Random((int)DateTime.Now.Ticks);
                _allFiles = _allFiles.OrderBy(a => rng.Next()).ToList();
                
                foreach(var s in _allFiles)
                {
                    Logger.Info(s);
                }
            }

            switch (outputIdx)
            {
                case (int)OutputId.Dynamic:
                    context.Dynamic = _allFiles;
                    break;
                case (int)OutputId.Count:
                    context.Value = _allFiles.Count;
                    break;
            }
            context.Value = _allFiles.Count;
            return context;
        }

        private void ScanDirectory(String path)
        {
            if (path.IndexOf("chat") >= 0)
            {
                foreach (var filename in Directory.GetFiles(path))
                {
                    var basename = filename.Split('\\').Last();
                    var filepath = path + "/" + basename;
                    FileInfo f = new FileInfo(filepath);
    	            
    	            if (f.Length > _minFileSize && f.Length < _maxFileSize && IsChatLog(filename))
    	            {
    	               _allFiles.Add(filepath);
    	            }
                }
            }
            foreach (var dir in Directory.GetDirectories(path))
            {
                var dirname = dir.Split('\\').Last();
                ScanDirectory(path + "/" + dirname);
            }
        }

        static bool IsChatLog(string filePath)
        {
            if (!File.Exists(filePath))
                return false;            

            FileStream stream = null;
            try
            {
                stream = new FileStream(filePath, FileMode.Open, FileAccess.Read);
            }
            catch
            {
                return false;
            }
            finally
            {
                Utilities.DisposeObj(ref stream);
            }

            return true;
        }

        private string _directoryPath;
        private List<String> _allFiles;
        private int _minFileSize;
        private int _maxFileSize;
    }
}

