//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using


namespace Framefield.Core.ID1f140717_cc1b_41ed_a2d6_3bf73aac8741
{
    public class Class_Replace : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            String = 0,
            Search = 1,
            Replace = 2
        }
        //<<< _inputids


        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var String = inputs[(int)InputId.String].Eval(context).Text;
            var Search = inputs[(int)InputId.Search].Eval(context).Text;
            var Replace = inputs[(int)InputId.Replace].Eval(context).Text;
            //<<< _params            
            
            if (String.IsNullOrEmpty(String) || String.IsNullOrEmpty(Search) || String.IsNullOrEmpty(Replace) ) {
                context.Text = String.Empty;
                return context;
            }            
            string result = string.Empty;
            context.Text = String.Replace(Search, Replace);            
            return context;
        }
    }
}

