//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDc23d5528_0970_4a95_9513_17211324a213
{
    public class Class_Remap : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Value = 0,
            RangeInMin = 1,
            RangeInMax = 2,
            RangeOutMin = 3,
            RangeOutMax = 4
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Value = inputs[(int)InputId.Value].Eval(context).Value;
            var RangeInMin = inputs[(int)InputId.RangeInMin].Eval(context).Value;
            var RangeInMax = inputs[(int)InputId.RangeInMax].Eval(context).Value;
            var RangeIn = new Vector2(RangeInMin, RangeInMax);
            var RangeOutMin = inputs[(int)InputId.RangeOutMin].Eval(context).Value;
            var RangeOutMax = inputs[(int)InputId.RangeOutMax].Eval(context).Value;
            var RangeOut = new Vector2(RangeOutMin, RangeOutMax);
            //<<< _params
            
            float factor = (Value - RangeInMin)/(RangeInMax - RangeInMin);
            context.Value = factor*(RangeOutMax - RangeOutMin) + RangeOutMin;
            
            return context;
        }
    }
}

