//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.IO;

namespace Framefield.Core.ID9f38aae8_c488_42ce_ad2a_6e45bed68268
{
    public class Class_LoadText : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            FilePath = 0
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var FilePath = inputs[(int)InputId.FilePath].Eval(context).Text;
            //<<< _params

            if( FilePath != _filepath) {
                _filepath = FilePath;
                if( !File.Exists( FilePath)) {
                    Logger.Error(this,"{0}: File not found: '{1}'", this.OperatorPart.Parent, FilePath);
                    context.Text= "";                
                }
                else {                
                    _content = File.ReadAllText(FilePath);
                }
                Changed = false;
                Logger.Info(this,"here");
            }
            
            context.Text = _content;
            return context;
        }
        
        string _filepath = ""; 
        string _content ="";        
    }
}

