//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Profiling;

namespace Framefield.Core.ID58ebb352_91df_4836_b221_1253318f2760
{
    public class Class_AverageFramerate : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            const int FRAME_COUNT = 10;
            context.Value = 0;
            if (TimeLogger.FrameCount > FRAME_COUNT)
            {
                var currentFrame = TimeLogger.LastFrame.Value;
                var lastNthFrame = TimeLogger.GetLastNthFrame(FRAME_COUNT).Value;
                var duration = (float)(currentFrame.StartTime - lastNthFrame.StartTime)/FRAME_COUNT;
                if (duration > 0)
                {
                    context.Value = 1.0f/duration;
                }                
            } 
            return context;
        }
    }
}


