//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDea237ad4_eb28_44a5_849c_5bb243ce91b7
{
    public class Class_Annotation : OperatorPart.Function,
                                  Framefield.Core.OperatorPartTraits.IAnnotation
    {
        //>>> _inputids
        private enum InputId
        {
            Height = 0,
            FontSize = 1,
            ColorR = 2,
            ColorG = 3,
            ColorB = 4,
            ColorA = 5,
            Text = 6
        }
        //<<< _inputids

        public string Text
        {
            get { return GetInputString((int)InputId.Text); } 
            set { SetInputString((int)InputId.Text, value); } 

        }


        public double Height
        {
            get { return GetInputValue((int)InputId.Height); } 
            set { SetInputValue((int)InputId.Height, value); } 
        }

        public double FontSize
        {
            get { return GetInputValue((int)InputId.FontSize); } 
            set { SetInputValue((int)InputId.FontSize, value); } 
        }

        public Color4 Color {
            get {
                return new Color4((float)GetInputValue((int)InputId.ColorR),
                                  (float)GetInputValue((int)InputId.ColorG),
                                  (float)GetInputValue((int)InputId.ColorB),
                                  (float)GetInputValue((int)InputId.ColorA));
            }
            set {
                SetInputValue((int)InputId.ColorR, (double)value.Alpha);
                SetInputValue((int)InputId.ColorG, (double)value.Red);
                SetInputValue((int)InputId.ColorB, (double)value.Green);
                SetInputValue((int)InputId.ColorA, (double)value.Blue);
            }
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            var prevValue = context.Value;
            //>>> _params
            var Height = inputs[(int)InputId.Height].Eval(context).Value;
            var FontSize = inputs[(int)InputId.FontSize].Eval(context).Value;
            var ColorR = inputs[(int)InputId.ColorR].Eval(context).Value;
            var ColorG = inputs[(int)InputId.ColorG].Eval(context).Value;
            var ColorB = inputs[(int)InputId.ColorB].Eval(context).Value;
            var ColorA = inputs[(int)InputId.ColorA].Eval(context).Value;
            var Color = new Color4(ColorR, ColorG, ColorB, ColorA);
            var Text = inputs[(int)InputId.Text].Eval(context).Text;
            //<<< _params

            // Just return without doing anything
            return context;
        }

        // Values
        private double GetInputValue(int index)
        {
            return OperatorPartUtilities.GetInputFloatValue(OperatorPart.Connections[index]);
        }

        private void SetInputValue(int index, double val)
        {
            OperatorPart opPart = OperatorPart.Connections[index];
            if (opPart.Connections.Count == 0)
            {
                opPart.Func = Utilities.CreateValueFunction(new Float((float)val));
            }
        }

        // Strings
        private string GetInputString(int index)
        {
            return OperatorPartUtilities.GetInputTextValue(OperatorPart.Connections[index]);
        }

        private void SetInputString(int index, string val)
        {
            OperatorPart opPart = OperatorPart.Connections[index];
            if (opPart.Connections.Count == 0)
            {
                opPart.Func = Utilities.CreateValueFunction(new Text((string)val));
            }
        }


        OperatorPart.InvalidateTimeAccessors _timeAccessorInvalidator = new OperatorPart.InvalidateTimeAccessors();
    }
}