
(function() {
	var Tree = function(main, id){
		this.Id = id;
		this.main = main;
	}
	var p = Tree.prototype = new wideload.BasePart();
	wideload.Tree = Tree;
	
	p.superInitialize = p.initialize;

	p.initialize = function(scene,container){
		this.superInitialize(scene,container);
    
    this.hayShader = wideload.HayShader();
    this.hayShader.uniforms.color.value = new THREE.Vector4(0.02, 0.1, 0.01, 0.03);
    this.hayShader.uniforms.divider.value = 6000.0;

		this.material = new THREE.ShaderMaterial({
			uniforms: this.hayShader.uniforms,
			attributes: this.hayShader.attributes,
			vertexShader: this.hayShader.vertex,
			fragmentShader: this.hayShader.fragment,
			color: "white",
			side: THREE.DoubleSide 
		});
    
    
    this.lsystem = new LSYSTEM();
    this.lsystem.interpret(5, 18, "F", "FFldFrFrFbdFtFtFubrdrFlFlFlFbdrFuFuFuFtb", 3);
  
    var geom = new THREE.Geometry();
    geom.dynamic = true;
    var ln = 8
    var df = Math.random()*1+1;
    
    for(var k = 0; k < this.lsystem.path.length; ++k){
    
      var from = new THREE.Vector3(this.lsystem.path[k].fromx, this.lsystem.path[k].fromy, this.lsystem.path[k].fromz);
      var to = new THREE.Vector3(this.lsystem.path[k].tox, this.lsystem.path[k].toy, this.lsystem.path[k].toz);
      
      geom.vertices.push(from);
      geom.vertices.push(new THREE.Vector3(from.x+df, from.y, from.z));
      
      geom.vertices.push(to);
      geom.vertices.push(new THREE.Vector3(to.x+df, to.y, to.z));
      

      geom.faces.push(new THREE.Face3(k*4, k*4+2, k*4+1));
      geom.faces.push(new THREE.Face3(k*4+2, k*4+3, k*4+1));
    }
    
    geom.mergeVertices();
    geom.verticesNeedUpdate = true;
    geom.facesNeedUpdate = true;
    
    //Generate random lines
    var line = new THREE.Mesh( geom, this.material);
    this.container.add(line);
	}
	
	p.internalUpdate = function(elapsedtime,renderTarget){
  
		var delta = this.main.clock.getDelta();
    var theta = this.main.clock.getElapsedTime();

		this.material.uniforms.wind.value.x= 0;//Math.sin(Math.cos(theta*5)+Math.sin(theta*.4)*0.4)*0.01+0.02;
		this.material.uniforms.wind.value.y = 0;//Math.cos(theta*3)*0.05+0.05;
	}

	
	
})();