#version 330 core

out vec4 color;

in vec2 UV;
uniform float iGlobalTime;
uniform float resx;
uniform float resy;
uniform sampler2D texture0;
uniform sampler2D iChannel0;

const vec3 SPHEREORIG = vec3(-0.5, -0.6, 1.3);
#define ROTMTX(t) rotationMatrix(vec3(0.4, 0.2, 0.4), 0.05 * t)


float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

mat3 rotationMatrix(vec3 axis, float angle)
{
    axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;
    
    return mat3(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,
                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,
                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c);
}

// ||origin + s*ray - o||^2 = 1
// (or.x + s*r.x - o.x)^2 + ... = 1
vec3 raysphere(vec3 origin, vec3 ray, out vec3 normal, out float dotfactor) {
	vec3 o = SPHEREORIG;
	vec3 delta = origin - o;
	float deltalen = length(delta);
	float c = deltalen * deltalen - 1.0;
	float b = 2.0 * dot(ray, origin - o);
	float a = 1.0; // length(ray)^2. Assumed to be normalized.
	float d = b*b - 4.0*a*c;
	if (d < 0.0) {
		normal = vec3(0.0);
		dotfactor = 0.0;
		return vec3(0.0,1.0,0.0);
	} else {
		float s = (-b + sqrt(d)) / (2.0 * a);
		vec3 intersectionpt = origin + s * ray;
		vec3 realnormal = normalize(intersectionpt - o);
		normal = normalize(realnormal);
		dotfactor = dot(realnormal, normalize(intersectionpt - origin));
		if (dotfactor < 0.0) {
			dotfactor = 0.0;
		} else {
			dotfactor = 0.2*(1.0 - pow(max(0.0, dotfactor - 0.5), 1.0/4.5));
		}
		return intersectionpt;
	}
	//s^2 * (r.x^2 + r.y^2 + r.z^2)
	//s * 2 * (r.x*(or.x - o.x) + r.y*(or.y - o.y) + r.z*(or.z - o.z))
	//(or.x-o.x)^2 + (or.y-o.y)^2 + (or.z-o.z)^2
	
}

float pointLine(vec3 x1, vec3 x2, vec3 x0) {
	float t = -dot(x1 - x0, x2 - x1) / dot(x2 - x1, x2 - x1);
	vec3 delta10 = x1 - x0;
	vec3 delta21 = x2 - x1;
	float d2 = pow(delta10.x + delta21.x*t, 2.0) +
		       pow(delta10.y + delta21.y*t, 2.0) +
		       pow(delta10.z + delta21.z*t, 2.0);
	return sqrt(d2);
}

//// Simplex noise from https://www.shadertoy.com/view/Msf3WH
vec2 hash( vec2 p )
{
	p = vec2( dot(p,vec2(127.1,311.7)),
			  dot(p,vec2(269.5,183.3)) );

	return -1.0 + 2.0*fract(sin(p)*43758.5453123);
}

float noise( in vec2 p )
{
    const float K1 = 0.366025404; // (sqrt(3)-1)/2;
    const float K2 = 0.211324865; // (3-sqrt(3))/6;

	vec2 i = floor( p + (p.x+p.y)*K1 );
	
    vec2 a = p - i + (i.x+i.y)*K2;
    vec2 o = (a.x>a.y) ? vec2(1.0,0.0) : vec2(0.0,1.0); //vec2 of = 0.5 + 0.5*vec2(sign(a.x-a.y), sign(a.y-a.x));
    vec2 b = a - o + K2;
	vec2 c = a - 1.0 + 2.0*K2;

    vec3 h = max( 0.5-vec3(dot(a,a), dot(b,b), dot(c,c) ), 0.0 );

	vec3 n = h*h*h*h*vec3( dot(a,hash(i+0.0)), dot(b,hash(i+o)), dot(c,hash(i+1.0)));

    return dot( n, vec3(70.0) );
	
}
//// Simplex noise

float halofactor(vec3 orig, vec3 hitp, vec3 planet) {
	// Planeetta = yksikkoepallo
	const float radius = 1.0;
	float od = length(orig - planet);

	// :......
	float mindist = od - radius - 1.0;
	float maxdist = 30.0 * sqrt(od * od + radius * radius);
	float hitdist = length(hitp - orig);

	return 0.0001*smoothstep(mindist, maxdist, hitdist);
}

void main(void)
{
	const vec3 lightdir = vec3(0.0, 0, 1.0);
//    vec2 p = gl_FragCoord.xy / vec2(resx, resy) - vec2(0.5);
//	vec2 uv = p*vec2(resx/resy,1.0);
	vec2 uv = (gl_FragCoord.xy / vec2(resx, resy) - vec2(0.5)) * vec2(resx / resy, 1.0);
	vec3 ray = normalize(vec3(uv, 1.0));
	vec3 origin = vec3(0.0);
	vec3 normalvec = vec3(0.0);
	float dotfactor = 0.0;
	vec3 collision = raysphere(origin, ray, normalvec, dotfactor);
	if (dotfactor < 0.1) {
		float d = pointLine(origin, origin+ray, vec3(-0.5, -0.6, 1.3));
		if (d < 1.0) {
			d = 0.0;
		} else {
			vec2 dirvec = normalize(vec2(uv.xy + 0.5));
//			d = pow(max(0.0, 0.5*exp(-20.5*(d - 1.0)) + 1.25 - 1.2*d + 0.5*noise( 20.0 * uv + 0.1*vec2(2.0*d+ 0.5*iGlobalTime))), 1.0);
			d = pow(max(0.0, 0.5*exp(-20.5*(d - 1.0)) + 0.7 - 0.6*sqrt(d) + 0.1*noise(4.0 * dirvec + 0.1*vec2(2.0*d+ 0.5*iGlobalTime))), 1.0);
			// d = d - 1.0;
		}
	}
	
	color = vec4(0.0, 1.4 * dotfactor, 2.0 * dotfactor, 1.0)
	      * texture(iChannel0, (ROTMTX(iGlobalTime)*normalvec).xy)*1.0
		  * max(0.5, dot(-normalize(normalvec), lightdir));
	//color.gb = color.gb * color.gb;

	color.xyz += 0.00015*noise(uv+15.0*iGlobalTime) + 0.003*noise(uv+vec2(0.0,18.4)+0.3*iGlobalTime);
	
//	color.x -= 0.02*smoothstep( -0.1, 1.1, ( sin(uv.x+iGlobalTime*0.08)+cos(uv.y-iGlobalTime*0.07) ) * 0.45*sqrt(color.x) )+0.0;
//	color.y -= 0.02*smoothstep( 0.0, 1.0, ( cos(1.1*uv.x-iGlobalTime*0.087)+cos(0.9*uv.y+iGlobalTime*0.071) ) * pow(1.5*color.y, 2.0) )+0.05;
//	color.z -= 0.03*smoothstep( 0.1, 0.88, ( sin(0.94*uv.x+iGlobalTime*0.063)-cos(uv.y+iGlobalTime*0.081) ) * 0.9*color.z )+0.1;
	
//		  + glowfactor
//		  + vec4(max(0.0, dot(vec3(0.0,0.0,1.0), -normalvec)))
//		  + vec4(halofactor(origin, collision, SPHEREORIG)); // * textureCube(iChannel1, ROTMTX(iGlobalTime)*ray);
}
