var LineBlob = (function () {

	"use strict";

	var _model,
		_duration = 0,
		_sync,
		_width,
		_height,
		_ctx,
		_preflightCallback,
		_s,
		_lb;

	var _screen,
		_mvpBase,
		_cube,
		_apeCtx;

	var _blackFade,
		_glow;

	function preflight(callbackFn, duration, model) {
		_preflightCallback = callbackFn;

		_duration = duration;
		_model = model;

		_sync = _model.sync;
		_width = _model.width();
		_height = _model.height();

		initSync();

		_ctx = _model.twoDeeRenderer;

		_preflightCallback();

		//barHeight = _height/2.5;
	}

	function init() {
		_model.on("resize", resize);

		Random.seed(42424242, 8000085, 1333337, 4242424);

		_lb = new LineBall();
		_lb.setContext(_ctx);

		_s = new Starfield();
		_s.setContext(_ctx);
		_s.setCenter(_width/2, _height);

		var canvas = document.createElement('canvas');
		_screen = new TRBLz.Screen(canvas, _width, _height);
		_cube = new TRBLz.Mesh.Ape();
		_mvpBase = new TRBLz.Matrix4();
		_mvpBase.perspective(120, _screen.aspect, 1, 100);
		_mvpBase.look_at(0, 0, -1.6, 0, 0, 0, 0, 1, 0);
		_apeCtx = canvas.getContext('2d');
	}

	function initSync() {
		_blackFade = _sync.getTrack('blackFade');
		_glow = _sync.getTrack('glow');
	}

	function render(row, sceneTime, frameDelta) {
		_ctx.fillStyle = '#FF8673';
		_ctx.fillRect(0, 0, _width, _height);

		_ctx.save();
		_ctx.globalAlpha = .5;
		_ctx.drawImage(Meat.pattern, 0, (_height - (Meat.pattern.height / 1080 * _height)) * 0.5, Meat.pattern.width / 1920 * _width, Meat.pattern.height / 1080 * _height);
		_ctx.restore();

		_ctx.save();
		_lb.render(row);
		_ctx.restore();

        _ctx.save();
        _ctx.globalCompositeOperation = "overlay";
        _ctx.drawImage(Meat.apeSprite, 0, 0, Meat.apeSprite.width / 1920 * _width, Meat.apeSprite.height / 1080 * _height);
        _ctx.restore();
//--
		var mvp = new TRBLz.Matrix4();
		mvp.set(_mvpBase);
		mvp.rotate(-row + 10, 1, 0, 0);
		mvp.rotate(-row + 20, 0, 1, 0);
		mvp.rotate(-row + 30, 0, 0, 1);

		_screen.clear();
		_cube.transform(mvp, _screen);
		//_cube.drawPoints(_screen);
		//_cube.drawLines(_screen);
		_cube.drawVertices(_screen);

		_ctx.drawImage(_apeCtx.canvas, (_width * .25),0);
//--
		var glow = _glow.getValue(row),
			bF = _blackFade.getValue(row);

		if (bF > 0) {
			_ctx.fillStyle = "rgba(0,0,0," + bF + ")";
			_ctx.fillRect(0, 0, _width, _height);
		}

		if (glow > 0) {
			var glowScale = 1;

			for (var i = 0; i < 4; i++) {
				glowScale += .01;
				var sW = _width * glowScale,
					sH = _height * glowScale;
				_ctx.save();
				_ctx.globalCompositeOperation = 'lighter';
				_ctx.globalAlpha = glow;
				_ctx.drawImage(_ctx.canvas, (_width - sW) / 2, (_height - sH) / 2, sW, sH);
				_ctx.restore();
			}
		}

		_ctx.drawImage(Meat.vignette, 0, 0, _width, _height);
	}

	function clear() {
		_model.on("resize", function () {
		});
	}

	function resize(width, height) {
		_width = width;
		_height = height;
	}

	return {
		preflight: preflight,
		init: init,
		render: render,
		clear: clear,
		resize: resize
	};
}());