var Intro = (function () {

	"use strict";

	var _model,
		_duration = 0,
		_sync,
		_width,
		_height,
		_ctx,
		_preflightCallback,
		_wave,
		_s;

	var barHeight;

	var _blackFade,
		_glow,
		_barheight,
		_color,
		_klumpen,
		_sAlpha,
		_sYoff;

	function preflight(callbackFn, duration, model) {
		_preflightCallback = callbackFn;

		_duration = duration;
		_model = model;

		_sync = _model.sync;
		_width = _model.width();
		_height = _model.height();

		initSync();

		_ctx = _model.twoDeeRenderer;

		_preflightCallback();


		//barHeight = _height/2.5;
	}

	function init() {
		_model.on("resize", resize);

		Random.seed(243234234, 456456234, 456456546, 3446534435);

		_wave = new WavingWave();
		_wave.setContext(_ctx);

		_s = new Starfield();
		_s.setContext(_ctx);
		_s.setCenter(_width/2, _height);

		_ctx.strokeStyle = '#000000';
	}

	function initSync() {
		_blackFade = _sync.getTrack('blackFade');
		_glow = _sync.getTrack('glow');
		_barheight = _sync.getTrack('0:barHeight');
		_color = _sync.getTrack('0:color');
		_klumpen = _sync.getTrack('0:width');
		_sAlpha = _sync.getTrack('0:sAlpha');
		_sYoff = _sync.getTrack('0:sYOff');
	}

	function render(row, sceneTime, frameDelta) {
		_ctx.fillStyle = '#8c8c8c';
		_ctx.fillRect(0,0,_width,_height);

		_ctx.save();
		_ctx.globalAlpha = .5;
		_ctx.drawImage(Meat.pattern, 0, (_height - (Meat.pattern.height / 1080 * _height)) * 0.5, Meat.pattern.width / 1920 * _width, Meat.pattern.height / 1080 * _height);
		_ctx.restore();

		_ctx.save();
		_s.setCenter(_width * 0.5, (_height * 0.5) + (_sYoff.getValue(row)) / 1080 * _height);
		_s.render(frameDelta/100);
		_ctx.fillStyle = '#8c8c8c';
		_ctx.globalAlpha = _sAlpha.getValue(row);
		_ctx.fillRect(0,0,_width,_height);
		_ctx.globalAlpha = 1;
		_ctx.restore();

		_ctx.save();
		_wave.render(row);
		_ctx.restore();

		_ctx.fillStyle = "#000";

		var barH = _barheight.getValue(row) / 1080 * _height,
			w = _klumpen.getValue(row) / 1920 * _width;
		if(w > 0){
			_ctx.fillRect(0, 0, w, _height);
		}

		_ctx.fillRect(0, 0, _width, barH);
		_ctx.fillRect(0, _height - barH, _width, barH);

		var glow = _glow.getValue(row),
			 bF = _blackFade.getValue(row);

		if (bF > 0) {
			_ctx.fillStyle = "rgba(0,0,0," + bF + ")";
			_ctx.fillRect(0, 0, _width, _height);
		}

		if (glow > 0) {
			var glowScale = 1;

			for(var i = 0; i < 4; i++ ){
				glowScale += .01;
				var sW = _width * glowScale,
					sH = _height * glowScale;
				_ctx.save();
				_ctx.globalCompositeOperation = 'lighter';
				_ctx.globalAlpha = glow;
				_ctx.drawImage(_ctx.canvas, (_width - sW) / 2, (_height - sH) / 2, sW, sH);
				_ctx.restore();
			}
		}

		_ctx.drawImage(Meat.vignette, 0, 0, _width, _height);
	}

	function clear() {
		_model.on("resize", function () {
		});
	}

	function resize(width, height) {
		_width = width;
		_height = height;
	}

	return {
		preflight: preflight,
		init: init,
		render: render,
		clear: clear,
		resize: resize
	};
}());