#version 120

uniform vec4 Color;
uniform vec4 EyePos;
uniform vec4 MiscFP;

varying vec3 pos;


void main(void)
{
	vec3 lightPos = EyePos.xyz;
	vec3 vecToLight = pos - lightPos;
	
	float distToLight = length(vecToLight);
	vec3 vecToLightNormalized = vecToLight / distToLight;


	float alpha = 1.0f- smoothstep( 0.0f, 1.0f, distToLight );
	
	gl_FragColor = vec4(Color.xyz, Color.w * alpha);
}