  //--------------------------------
  // VERTEX FUR  
  //--------------------------------
  // By Evolved
  // http://www.vector3r.com/
  //--------------------------------

  //--------------------------------
  // un-tweaks
  //--------------------------------
   matrix WorldVP:WorldViewProjection; 
   matrix World:World;   

  //--------------------------------
  // tweaks
  //--------------------------------
   float4 FurColor = {1.0f, 0.8f, 0.0f, 1.0f};
   float  FurHeight = 0.1f;
   float4 LightPosition = {0.0f, 50.0f, -100.0f, 1.0f};    
   float4 LightColor = {1.0f, 1.0f, 1.0f, 1.0f};    
   float  LightRange = 125.0f;
   float4 Ambient = {0.3f, 0.3f, 0.3f, 1.0f};
   float U = 1.0f; 
   float V = 1.0f; 

  //--------------------------------
  // Textures
  //--------------------------------
   texture FurTX 
      <
	string Name="";
      >;	
   sampler2D Fur = sampler_state 
      {
 	texture = <FurTX>;
      };

  //--------------------------------
  // structs
  //--------------------------------
   struct Input
      {
    	float4 Pos:POSITION; 
    	float2 UV:TEXCOORD; 
 	float3 Normal:NORMAL;  
      };
   struct Output
      {
    	float4 OPos:POSITION; 
    	float2 Tex:TEXCOORD0; 
     	float4 Diffuse:COLOR0; 
      };

  //--------------------------------
  // vertex shader
  //--------------------------------
   Output VS(Input IN,uniform float Dir) 
      {
    	Output OUT;
	float4 VPos;
	VPos.xyz=IN.Pos+(IN.Normal*(Dir*FurHeight));VPos.w=IN.Pos.w;
  	OUT.OPos=mul(VPos,WorldVP);
	OUT.Tex=IN.UV*float2(U,V);
	float3 WNor=mul(IN.Normal,World); WNor=normalize(WNor);
	float3 WPos=mul(IN.Pos,World); 
  	float3 LPos=LightPosition-WPos;
   	float4 Light=max(saturate(0.025f+mul(LPos,WNor)*0.025f),0);
	float Dis=max(saturate(1-(length(LPos)/LightRange)),0);
  	OUT.Diffuse=(Ambient+(Light*Dis*LightColor))*FurColor; 
  	return OUT;
      }

  //-----------------
  // techniques 
  //-----------------
    technique VFur
      {
 	pass p0
      {		
 	vertexShader = compile vs_1_1 VS(0); 
        Sampler[0] = <Fur>;
  	ColorOp[0]   = MODULATE;
        ColorArg1[0] = TEXTURE;
      	SRCBLEND = SRCALPHA;
      	DESTBLEND = ZERO;
      	ALPHABLENDENABLE = TRUE;
     	BLENDOP = ADD;
      }
  	pass p1
      {		
 	vertexShader = compile vs_1_1 VS(1); 
        Sampler[0] = <Fur>;
  	ColorOp[0]   = MODULATE;
        ColorArg1[0] = TEXTURE;
      	SRCBLEND = SRCALPHA;
      	DESTBLEND = ONE;
      	ALPHABLENDENABLE = TRUE;
      	BLENDOP = ADD;
      }
  	pass p2
      {		
 	vertexShader = compile vs_1_1 VS(2); 
        Sampler[0] = <Fur>;
  	ColorOp[0]   = MODULATE;
        ColorArg1[0] = TEXTURE;
      }
  	pass p3
      {		
 	vertexShader = compile vs_1_1 VS(3); 
        Sampler[0] = <Fur>;
  	ColorOp[0]   = MODULATE;
        ColorArg1[0] = TEXTURE; 
      }
  	pass p4
      {		
 	vertexShader = compile vs_1_1 VS(4); 
        Sampler[0] = <Fur>;
  	ColorOp[0]   = MODULATE;
        ColorArg1[0] = TEXTURE;
      }
  	pass p5
      {		
 	vertexShader = compile vs_1_1 VS(5); 
        Sampler[0] = <Fur>;
  	ColorOp[0]   = MODULATE;
        ColorArg1[0] = TEXTURE;
      }
  	pass p6
      {		
 	vertexShader = compile vs_1_1 VS(6); 
        Sampler[0] = <Fur>;
  	ColorOp[0]   = MODULATE;
        ColorArg1[0] = TEXTURE;
      }
  	pass p7
      {		
 	vertexShader = compile vs_1_1 VS(7); 
        Sampler[0] = <Fur>;
  	ColorOp[0]   = MODULATE;
        ColorArg1[0] = TEXTURE; 
      }
  	pass p8
      {		
 	vertexShader = compile vs_1_1 VS(8); 
        Sampler[0] = <Fur>;
  	ColorOp[0]   = MODULATE;
        ColorArg1[0] = TEXTURE; 
      }
  	pass p9
      {		
 	vertexShader = compile vs_1_1 VS(9); 
        Sampler[0] = <Fur>;
  	ColorOp[0]   = MODULATE;
        ColorArg1[0] = TEXTURE;
      }
      }