ig.module( 
    'game.entities.potion' 
)
.requires(
    'impact.entity' 
)

.defines(function(){

// Play this when a character spawns in a or leaves a map.
EntityPotion = ig.Entity.extend({

    animSheet: new ig.AnimationSheet( 'media/potion.png', 16, 25 ),
    collides: ig.Entity.COLLIDES.NEVER,
    size: {x: 16, y:25},
    id: -1,
    zIndex: 5,

    init: function( x, y, settings ) {
        this.parent(x, y, settings);

        this.id = settings.id;

        this.addAnim('default', 1, [0] );

        if(!ig.editor){
            // Re-sort Entities
            ig.game.sortEntitiesDeferred();
        }
    }
})
});