/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;
import processing.core.PApplet;

public class LANTycoon
extends PApplet {
    Game game;
    int tycoonState;
    String superLongHowToString = "Welcome to LANTycoon\nThis is a very simple tycoon game made for The Gathering 2013 NGA Fast Game Development compo. The theme for this years compo was \"Time is money\".\nThe game is developet by Emil Lie Hatlelid and Kyrre Havik Eriksen from University of Oslo (visit our UIO:Campus TG stand!)\nIn the following section we will try to explain how the game is played.\n\n- The goal is to earn as much money as possible untill the end of 2013! This is done by making succesefull LAN partys.\n- Of course, if you run out of money you will lose, by the end of that year :(\n- You earn money by participants visitng your party, and bonus/multipliers made from having stands. The bigger LAN, the better!\n- The thing is, you have only a set amount of time before a LAN party starts. So you need to build quick, or buy the long tables with more seats. Since they are quicker to build\n- Each LAN hall also cost money to rent (except the first one). So you need to add this to your price calculation.- Each table square have room for two particpants, so don't make it to close or else you miss seats.- There are some exception to this last rule (It's not a bug, it's a feature!).- You can sell seats or stand by pressing 'd' while hovering over.";

    public void setup() {
        this.size(800, 500);
        this.background(0);
        this.game = new Game();
        this.tycoonState = 0;
    }

    public void draw() {
        this.background(0);
        switch (this.tycoonState) {
            case 0: {
                this.fill(this.random(255.0f), this.random(255.0f), this.random(255.0f));
                this.textAlign(3);
                this.textSize(56.0f);
                this.text("LAN Tycoon", 250.0f, 250.0f);
                this.fill(this.random(255.0f), this.random(255.0f), this.random(255.0f));
                this.textSize(21.0f);
                this.text("Press the any-key", 250.0f, 280.0f);
                break;
            }
            case 1: {
                this.fill(255);
                this.textAlign(37);
                this.textSize(14.0f);
                this.text(this.superLongHowToString, 10.0f, 10.0f, 790.0f, 490.0f);
                this.textAlign(39);
                this.textSize(21.0f);
                this.text("Press the any-key again", 495.0f, 495.0f);
                break;
            }
            case 2: {
                this.game.draw();
                break;
            }
        }
    }

    public void mousePressed() {
        switch (this.tycoonState) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.game.mousePressed();
                break;
            }
        }
    }

    public void mouseReleased() {
        switch (this.tycoonState) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.game.mouseReleased();
                break;
            }
        }
    }

    public void mouseDragged() {
        switch (this.tycoonState) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.game.mouseDragged();
                break;
            }
        }
    }

    public void mouseClicked() {
        switch (this.tycoonState) {
            case 0: {
                this.tycoonState = 1;
                break;
            }
            case 1: {
                this.tycoonState = 2;
                break;
            }
            case 2: {
                this.game.mouseClicked();
                break;
            }
        }
    }

    public void keyPressed() {
        switch (this.tycoonState) {
            case 0: {
                this.tycoonState = 1;
                break;
            }
            case 1: {
                this.tycoonState = 2;
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void keyReleased() {
        switch (this.tycoonState) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.game.keyReleased();
                break;
            }
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--stop-color=#cccccc", "LANTycoon"};
        if (stringArray != null) {
            PApplet.main((String[])LANTycoon.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class Cube {
        int x;
        int y;
        int r;
        int g;
        int b;
        int value;
        int price;
        int maxSeats;
        int seats;
        int tempSeats;
        int w;
        int h;
        char type;
        boolean vertical;
        boolean checked;

        public Cube(int n, int n2, char c) {
            this.x = n;
            this.y = n2;
            this.type = c;
            switch (c) {
                case 'T': {
                    this.w = 40;
                    this.h = 10;
                    this.r = 134;
                    this.g = 120;
                    this.b = 39;
                    this.price = 800;
                    this.seats = 8;
                    break;
                }
                case 't': {
                    this.w = 20;
                    this.h = 10;
                    this.r = 134;
                    this.g = 120;
                    this.b = 39;
                    this.price = 300;
                    this.seats = 4;
                    break;
                }
                case 'B': {
                    this.w = 10;
                    this.h = 10;
                    this.r = 134;
                    this.g = 120;
                    this.b = 39;
                    this.price = 100;
                    this.seats = 2;
                    break;
                }
                case 'U': {
                    this.w = 80;
                    this.h = 30;
                    this.r = 255;
                    this.g = 0;
                    this.b = 0;
                    this.price = 2000;
                    break;
                }
                case 'K': {
                    this.w = 100;
                    this.h = 80;
                    this.r = 0;
                    this.g = 128;
                    this.b = 255;
                    this.price = 50000;
                    break;
                }
                case 'R': {
                    this.w = 60;
                    this.h = 20;
                    this.r = 100;
                    this.g = 100;
                    this.b = 100;
                    this.price = 1500;
                    break;
                }
                case 'E': {
                    this.w = 20;
                    this.h = 10;
                    this.r = 0;
                    this.g = 250;
                    this.b = 0;
                }
            }
        }

        public void draw() {
            LANTycoon.this.fill(this.r, this.g, this.b);
            LANTycoon.this.rect(this.x, this.y, this.w, this.h);
            if (this.seats > 0) {
                LANTycoon.this.fill(255);
                LANTycoon.this.textAlign(3);
                LANTycoon.this.textSize(10.0f);
                LANTycoon.this.text(this.seats - this.tempSeats, this.x + this.w / 2, this.y + this.h - 1);
            }
        }

        public void update() {
            this.x = LANTycoon.this.mouseX / 10 * 10;
            this.y = LANTycoon.this.mouseY / 10 * 10;
        }

        public boolean available(Cube cube) {
            if (cube.x >= this.x + this.w) {
                return true;
            }
            if (cube.y >= this.y + this.h) {
                return true;
            }
            if (cube.x + cube.w <= this.x) {
                return true;
            }
            return cube.y + cube.h <= this.y;
        }

        public void clearSeats(List<Cube> list) {
            this.tempSeats = 0;
            for (Cube cube : list) {
                int n;
                int n2;
                cube.tempSeats = 0;
                if (this.vertical && cube.vertical) {
                    n2 = 0;
                    while (n2 < this.h / 10) {
                        n = 0;
                        while (n < cube.h / 10) {
                            if ((this.x == cube.x + this.w || this.x + this.w == cube.x) && this.y + n2 * 10 == cube.y + n * 10) {
                                ++this.tempSeats;
                                ++cube.tempSeats;
                            }
                            ++n;
                        }
                        ++n2;
                    }
                    continue;
                }
                if (this.vertical) {
                    n2 = 0;
                    while (n2 < cube.w / 10) {
                        if (this.x == cube.x + n2 * 10 && (this.y == cube.y + cube.h || this.y + this.h == cube.y)) {
                            ++cube.tempSeats;
                        }
                        ++n2;
                    }
                    n2 = 0;
                    while (n2 < this.h / 10) {
                        if (cube.y == this.y + n2 * 10 && (this.x == cube.x + cube.w || this.x + this.w == cube.x)) {
                            ++this.tempSeats;
                        }
                        ++n2;
                    }
                    continue;
                }
                if (cube.vertical) {
                    n2 = 0;
                    while (n2 < this.w / 10) {
                        if (cube.x == this.x + n2 * 10 && (cube.y == this.y + this.h || cube.y + cube.h == this.y)) {
                            ++this.tempSeats;
                        }
                        ++n2;
                    }
                    n2 = 0;
                    while (n2 < cube.h / 10) {
                        if (this.y == cube.y + n2 * 10 && (cube.x == this.x + this.w || cube.x + cube.w == this.x)) {
                            ++cube.tempSeats;
                        }
                        ++n2;
                    }
                    continue;
                }
                n2 = 0;
                while (n2 < this.w / 10) {
                    n = 0;
                    while (n < cube.w / 10) {
                        if ((this.y == cube.y + this.h || this.y + this.h == cube.y) && this.x + n2 * 10 == cube.x + n * 10) {
                            ++this.tempSeats;
                            ++cube.tempSeats;
                        }
                        ++n;
                    }
                    ++n2;
                }
            }
            int n = 0;
            while (n < this.w / 10) {
                if (this.y + this.h == LANTycoon.this.game.hmaxh || this.y == LANTycoon.this.game.hminh) {
                    ++this.tempSeats;
                }
                ++n;
            }
        }

        public void saveClearSeats(List<Cube> list) {
            this.tempSeats = 0;
            for (Cube cube : list) {
                int n;
                int n2;
                cube.tempSeats = 0;
                if (this.vertical && cube.vertical) {
                    n2 = 0;
                    while (n2 < this.h / 10) {
                        n = 0;
                        while (n < cube.h / 10) {
                            if ((this.x == cube.x + this.w || this.x + this.w == cube.x) && this.y + n2 * 10 == cube.y + n * 10) {
                                --this.seats;
                                --cube.seats;
                            }
                            ++n;
                        }
                        ++n2;
                    }
                    continue;
                }
                n2 = 0;
                while (n2 < this.w / 10) {
                    n = 0;
                    while (n < cube.w / 10) {
                        if ((this.y == cube.y + this.h || this.y + this.h == cube.y) && this.x + n2 * 10 == cube.x + n * 10) {
                            --this.seats;
                            --cube.seats;
                        }
                        ++n;
                    }
                    ++n2;
                }
            }
            int n = 0;
            while (n < this.w / 10) {
                if (this.y + this.h == LANTycoon.this.game.hmaxh || this.y == LANTycoon.this.game.hminh) {
                    --this.seats;
                }
                ++n;
            }
        }
    }

    class Game {
        List<Cube> cubes = new ArrayList<Cube>();
        Cube tempCube;
        Cube ent;
        int gameState = 0;
        int lanHall = -1;
        int hminw;
        int hmaxw;
        int hminh;
        int hmaxh;
        long time;
        long money = 1000L;
        long year = 1992L;
        long roundTime = 120000L;
        long lastMillis;
        boolean hallDrawn;
        boolean gameCompleted = true;
        int[] results;

        public void draw() {
            switch (this.gameState) {
                case 0: {
                    LANTycoon.this.fill(255);
                    LANTycoon.this.textAlign(37);
                    LANTycoon.this.textSize(21.0f);
                    LANTycoon.this.text("Choose your LAN hall:", 30.0f, 30.0f);
                    LANTycoon.this.textSize(16.0f);
                    LANTycoon.this.text("Money: " + this.money, 500.0f, 60.0f);
                    LANTycoon.this.stroke(255);
                    LANTycoon.this.fill(102.0f, 51.0f, 0.0f);
                    LANTycoon.this.rect(100.0f, 100.0f, 50.0f, 50.0f);
                    LANTycoon.this.text("Menighetshus\n0,-", 160.0f, 117.0f);
                    if (this.money >= 1000L) {
                        LANTycoon.this.fill(255.0f, 0.0f, 0.0f);
                    } else {
                        LANTycoon.this.fill(100);
                    }
                    LANTycoon.this.rect(320.0f, 100.0f, 50.0f, 50.0f);
                    LANTycoon.this.text("Gymsal\n1 000,-", 380.0f, 117.0f);
                    if (this.money >= 5000L) {
                        LANTycoon.this.fill(0.0f, 255.0f, 0.0f);
                    } else {
                        LANTycoon.this.fill(100);
                    }
                    LANTycoon.this.rect(100.0f, 300.0f, 50.0f, 50.0f);
                    LANTycoon.this.text("Flerbrukshall\n5 000,-", 160.0f, 317.0f);
                    if (this.money >= 10000L) {
                        LANTycoon.this.fill(0.0f, 0.0f, 255.0f);
                    } else {
                        LANTycoon.this.fill(100);
                    }
                    LANTycoon.this.rect(320.0f, 300.0f, 50.0f, 50.0f);
                    LANTycoon.this.text("Vikingskipet\n10 000,-", 380.0f, 317.0f);
                    LANTycoon.this.noStroke();
                    break;
                }
                case 1: {
                    if ((long)LANTycoon.this.millis() > this.lastMillis + 1000L) {
                        this.time -= 1000L;
                        this.lastMillis = LANTycoon.this.millis();
                    }
                    if (this.time <= 0L) {
                        this.gameState = 2;
                        this.calculateStats();
                        return;
                    }
                    this.grid();
                    this.menu();
                    this.stats();
                    this.ent.draw();
                    for (Cube cube : this.cubes) {
                        cube.draw();
                    }
                    if (this.tempCube == null) break;
                    this.tempCube.update();
                    this.tempCube.draw();
                    break;
                }
                case 2: {
                    this.grid();
                    for (Cube cube : this.cubes) {
                        cube.draw();
                    }
                    LANTycoon.this.textAlign(37);
                    LANTycoon.this.fill(0, 50.0f);
                    LANTycoon.this.rect(-10.0f, -10.0f, LANTycoon.this.displayWidth, LANTycoon.this.displayHeight);
                    LANTycoon.this.fill(121.0f, 121.0f, 121.0f, 199.0f);
                    LANTycoon.this.rect(25.0f, 25.0f, 750.0f, 450.0f);
                    LANTycoon.this.fill(250);
                    LANTycoon.this.textSize(24.0f);
                    LANTycoon.this.text("SCORE", 100.0f, 110.0f);
                    LANTycoon.this.line(90.0f, 120.0f, 190.0f, 120.0f);
                    LANTycoon.this.pushMatrix();
                    LANTycoon.this.textSize(21.0f);
                    LANTycoon.this.fill(LANTycoon.this.random(255.0f), LANTycoon.this.random(255.0f), LANTycoon.this.random(255.0f));
                    LANTycoon.this.translate(200.0f, 200.0f);
                    LANTycoon.this.rotate(LANTycoon.radians((float)10.471975f));
                    LANTycoon.this.text("TG-" + (this.year - 1L) + " FINISHED!", -100.0f, -100.0f);
                    LANTycoon.this.popMatrix();
                    LANTycoon.this.fill(150);
                    LANTycoon.this.textSize(18.0f);
                    LANTycoon.this.text("Year:   " + (this.year - 1L) + "\nExpenses: " + this.results[2] + "\nTicketsales: " + this.results[1] + "\nStand attraction " + this.results[0] + "\n\n\n\nNet Income: " + this.results[4], 100.0f, 150.0f);
                    LANTycoon.this.textSize(22.0f);
                    LANTycoon.this.fill(250);
                    LANTycoon.this.text("INCOME: " + this.results[3], 100.0f, 300.0f);
                    LANTycoon.this.textSize(21.0f);
                    LANTycoon.this.textAlign(3);
                    if (this.year < 2014L && this.money > 99L) {
                        LANTycoon.this.text("CLICK\nTO CONTINUE\n(or esc to quit)", 500.0f, 250.0f);
                        break;
                    }
                    LANTycoon.this.text("CLICK\nTO QUIT", 500.0f, 250.0f);
                }
            }
        }

        public void menu() {
            LANTycoon.this.pushMatrix();
            LANTycoon.this.textAlign(37);
            LANTycoon.this.fill(200.0f, 200.0f, 200.0f);
            LANTycoon.this.translate(500.0f, 0.0f);
            LANTycoon.this.textSize(12.0f);
            LANTycoon.this.fill(0);
            LANTycoon.this.rect(0.0f, -1.0f, 300.0f, 500.0f);
            LANTycoon.this.fill(200);
            LANTycoon.this.stroke(255);
            LANTycoon.this.text("TABLE", 15.0f, 20.0f);
            LANTycoon.this.text("800,-", 5.0f, 40.0f);
            LANTycoon.this.text("300,-", 5.0f, 60.0f);
            LANTycoon.this.text("100,-", 5.0f, 80.0f);
            LANTycoon.this.text("UiO", 20.0f, 130.0f);
            LANTycoon.this.text("2 000,-", 5.0f, 150.0f);
            LANTycoon.this.text("KOMPLETT.NO", 20.0f, 200.0f);
            LANTycoon.this.text("50 000,-", 5.0f, 220.0f);
            LANTycoon.this.text("RND STAND", 20.0f, 315.0f);
            LANTycoon.this.text("1 500,-", 5.0f, 335.0f);
            LANTycoon.this.fill(134.0f, 120.0f, 39.0f);
            LANTycoon.this.rect(60.0f, 30.0f, 40.0f, 10.0f);
            LANTycoon.this.rect(60.0f, 50.0f, 20.0f, 10.0f);
            LANTycoon.this.rect(60.0f, 70.0f, 10.0f, 10.0f);
            LANTycoon.this.fill(255.0f, 0.0f, 0.0f);
            LANTycoon.this.rect(60.0f, 140.0f, 100.0f, 30.0f);
            LANTycoon.this.fill(0.0f, 128.0f, 255.0f);
            LANTycoon.this.rect(60.0f, 210.0f, 100.0f, 80.0f);
            LANTycoon.this.fill(100.0f, 100.0f, 100.0f);
            LANTycoon.this.rect(60.0f, 325.0f, 60.0f, 20.0f);
            LANTycoon.this.popMatrix();
        }

        public void grid() {
            if (!this.hallDrawn) {
                switch (this.lanHall) {
                    case 0: {
                        this.hminw = 200;
                        this.hmaxw = 300;
                        this.hminh = 200;
                        this.hmaxh = 250;
                        this.ent = new Cube(this.hminw, this.hmaxh, 'E');
                        break;
                    }
                    case 1: {
                        this.hminw = 150;
                        this.hmaxw = 350;
                        this.hminh = 200;
                        this.hmaxh = 300;
                        this.ent = new Cube(this.hminw, this.hmaxh, 'E');
                        break;
                    }
                    case 2: {
                        this.hminw = 50;
                        this.hmaxw = 450;
                        this.hminh = 200;
                        this.hmaxh = 400;
                        this.ent = new Cube(this.hminw, this.hmaxh, 'E');
                        break;
                    }
                    case 3: {
                        this.hminw = 50;
                        this.hmaxw = 450;
                        this.hminh = 50;
                        this.hmaxh = 450;
                        this.ent = new Cube(this.hminw, this.hmaxh, 'E');
                    }
                }
                this.hallDrawn = true;
            }
            LANTycoon.this.stroke(64);
            int n = this.hminw;
            while (n < this.hmaxw) {
                LANTycoon.this.line(n, this.hminh, n, this.hmaxh);
                int n2 = this.hminh;
                while (n2 < this.hmaxh) {
                    LANTycoon.this.line(this.hminw, n2, this.hmaxw, n2);
                    n2 += 10;
                }
                n += 10;
            }
            LANTycoon.this.line(this.hmaxw, this.hminh, this.hmaxw, this.hmaxh);
            LANTycoon.this.line(this.hminw, this.hmaxh, this.hmaxw, this.hmaxh);
            LANTycoon.this.stroke(255);
        }

        public void stats() {
            int n = 520;
            LANTycoon.this.fill(51.0f, 51.0f, 51.0f);
            LANTycoon.this.rect(n + 170, 470.0f, 109.0f, 29.0f);
            LANTycoon.this.fill(255);
            LANTycoon.this.line(500.0f, 350.0f, 800.0f, 350.0f);
            LANTycoon.this.textAlign(37);
            LANTycoon.this.textSize(18.0f);
            LANTycoon.this.text("TIME: " + this.time / 1000L + " seconds", n, 370.0f);
            LANTycoon.this.text("MONEY: " + this.money, n, 400.0f);
            LANTycoon.this.text("YEAR: " + this.year, n, 430.0f);
            LANTycoon.this.text("IM READY!", n + 180, 491.0f);
        }

        public void calculateStats() {
            this.time = this.roundTime;
            ++this.year;
            this.results = this.calculateProfits();
            this.money += (long)this.results[3];
        }

        public void mousePressed() {
            switch (this.gameState) {
                case 0: {
                    break;
                }
                case 1: {
                    if (LANTycoon.this.mouseX > 500 && LANTycoon.this.mouseY < 344) {
                        if (LANTycoon.this.mouseY > 324 && LANTycoon.this.mouseY < 344) {
                            this.tempCube = new Cube(LANTycoon.this.mouseX, LANTycoon.this.mouseY, 'R');
                            break;
                        }
                        if (LANTycoon.this.mouseY > 209 && LANTycoon.this.mouseY < 289) {
                            this.tempCube = new Cube(LANTycoon.this.mouseX, LANTycoon.this.mouseY, 'K');
                            break;
                        }
                        if (LANTycoon.this.mouseY > 139 && LANTycoon.this.mouseY < 169) {
                            this.tempCube = new Cube(LANTycoon.this.mouseX, LANTycoon.this.mouseY, 'U');
                            break;
                        }
                        if (LANTycoon.this.mouseY > 69 && LANTycoon.this.mouseY < 79) {
                            this.tempCube = new Cube(LANTycoon.this.mouseX, LANTycoon.this.mouseY, 'B');
                            break;
                        }
                        if (LANTycoon.this.mouseY > 49 && LANTycoon.this.mouseY < 59) {
                            this.tempCube = new Cube(LANTycoon.this.mouseX, LANTycoon.this.mouseY, 't');
                            break;
                        }
                        if (LANTycoon.this.mouseY <= 29 || LANTycoon.this.mouseY >= 39) break;
                        this.tempCube = new Cube(LANTycoon.this.mouseX, LANTycoon.this.mouseY, 'T');
                        break;
                    }
                    if (LANTycoon.this.mouseX <= 500) break;
                    break;
                }
            }
        }

        public void mouseReleased() {
            switch (this.gameState) {
                case 0: {
                    break;
                }
                case 1: {
                    if (LANTycoon.this.mouseButton == 39 && this.tempCube != null) {
                        int n = this.tempCube.w;
                        this.tempCube.w = this.tempCube.h;
                        this.tempCube.h = n;
                        this.tempCube.vertical = !this.tempCube.vertical;
                        break;
                    }
                    if (LANTycoon.this.mouseButton != 37 || this.tempCube == null) break;
                    if (LANTycoon.this.mouseX > this.hminw && LANTycoon.this.mouseY > this.hminh && LANTycoon.this.mouseX <= 10 + this.hmaxw - this.tempCube.w && LANTycoon.this.mouseY <= 10 + this.hmaxh - this.tempCube.h) {
                        for (Cube cube : this.cubes) {
                            if (cube.available(this.tempCube)) continue;
                            this.tempCube = null;
                            return;
                        }
                        if (this.money < (long)this.tempCube.price) {
                            this.tempCube = null;
                            return;
                        }
                        this.tempCube.saveClearSeats(this.cubes);
                        this.money -= (long)this.tempCube.price;
                        this.cubes.add(this.tempCube);
                        this.tempCube = null;
                        break;
                    }
                    this.tempCube = null;
                    break;
                }
            }
        }

        public void mouseClicked() {
            switch (this.gameState) {
                case 0: {
                    if (LANTycoon.this.mouseX > 100 && LANTycoon.this.mouseX < 150 && LANTycoon.this.mouseY > 100 && LANTycoon.this.mouseY < 150) {
                        this.lanHall = 0;
                    } else if (LANTycoon.this.mouseX > 320 && LANTycoon.this.mouseX < 370 && LANTycoon.this.mouseY > 100 && LANTycoon.this.mouseY < 150 && this.money >= 1000L) {
                        this.money -= 1000L;
                        this.lanHall = 1;
                    } else if (LANTycoon.this.mouseX > 100 && LANTycoon.this.mouseX < 150 && LANTycoon.this.mouseY > 300 && LANTycoon.this.mouseY < 350 && this.money >= 5000L) {
                        this.money -= 5000L;
                        this.lanHall = 2;
                    } else if (LANTycoon.this.mouseX > 320 && LANTycoon.this.mouseX < 370 && LANTycoon.this.mouseY > 300 && LANTycoon.this.mouseY < 350 && this.money >= 10000L) {
                        this.money -= 10000L;
                        this.lanHall = 3;
                    } else {
                        return;
                    }
                    this.time = this.roundTime;
                    this.lastMillis = LANTycoon.this.millis();
                    this.gameState = 1;
                    break;
                }
                case 1: {
                    if (LANTycoon.this.mouseX <= 689 || LANTycoon.this.mouseY <= 469) break;
                    this.gameState = 2;
                    this.calculateStats();
                    break;
                }
                case 2: {
                    this.cubes = new ArrayList<Cube>();
                    this.hallDrawn = false;
                    if (this.year > 2013L || this.money < 99L) {
                        this.gameState = 0;
                        this.lanHall = -1;
                        this.roundTime = 120000L;
                        this.year = 1992L;
                        this.money = 1000L;
                        LANTycoon.this.tycoonState = 0;
                        break;
                    }
                    this.gameState = 0;
                }
            }
        }

        public void mouseDragged() {
            switch (this.gameState) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.tempCube == null) break;
                    this.tempCube.clearSeats(this.cubes);
                    break;
                }
            }
        }

        public int[] calculateProfits() {
            int n = 0;
            int n2 = 0;
            float f = 1.0f;
            int n3 = 100 + this.lanHall * 100;
            for (Cube object2 : this.cubes) {
                switch (object2.type) {
                    case 'T': {
                        n += object2.price;
                        n2 += n3 * object2.seats;
                        break;
                    }
                    case 't': {
                        n += object2.price;
                        n2 += n3 * object2.seats;
                        break;
                    }
                    case 'B': {
                        n += object2.price;
                        n2 += n3 * object2.seats;
                        break;
                    }
                    case 'U': {
                        n += object2.price;
                        f += 0.15f;
                        break;
                    }
                    case 'K': {
                        n += object2.price;
                        f += 0.75f;
                        break;
                    }
                    case 'R': {
                        n += object2.price;
                        f += 0.1f;
                        break;
                    }
                }
            }
            int[] nArray = new int[]{LANTycoon.round((float)(f * 100.0f)), n2, n, LANTycoon.round((float)((float)n2 * f)), LANTycoon.round((float)((float)n2 * f)) - n};
            return nArray;
        }

        public void keyReleased() {
            switch (this.gameState) {
                case 0: {
                    break;
                }
                case 1: {
                    if (LANTycoon.this.key != 'd' || this.tempCube != null || LANTycoon.this.mouseX <= this.hminw || LANTycoon.this.mouseX >= this.hmaxw || LANTycoon.this.mouseY <= this.hminh || LANTycoon.this.mouseY >= this.hmaxh) break;
                    Cube cube = null;
                    for (Cube cube2 : this.cubes) {
                        if (LANTycoon.this.mouseX <= cube2.x || LANTycoon.this.mouseX >= cube2.x + cube2.w || LANTycoon.this.mouseY <= cube2.y || LANTycoon.this.mouseY >= cube2.y + cube2.h) continue;
                        cube = cube2;
                        break;
                    }
                    if (cube == null) break;
                    this.cubes.remove(cube);
                    this.money += (long)cube.price;
                    break;
                }
            }
        }
    }
}

