/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.swt;

import com.jogamp.common.util.RunnableTask;
import com.jogamp.newt.util.EDTUtil;
import javax.media.nativewindow.NativeWindowException;
import jogamp.newt.Debug;
import jogamp.newt.DisplayImpl;
import org.eclipse.swt.widgets.Display;

public class SWTEDTUtil
implements EDTUtil {
    public static final boolean DEBUG = Debug.debug("EDT");
    private final Object edtLock = new Object();
    private final ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
    private final String name;
    private final Runnable dispatchMessages;
    private final Display swtDisplay;
    private NewtEventDispatchThread nedt = null;
    private int start_iter = 0;
    private static long pollPeriod = 10L;

    public SWTEDTUtil(final com.jogamp.newt.Display display, Display display2) {
        this.name = Thread.currentThread().getName() + "-SWTDisplay-" + display.getFQName() + "-EDT-";
        this.dispatchMessages = new Runnable(){

            @Override
            public void run() {
                ((DisplayImpl)display).dispatchMessages();
            }
        };
        this.swtDisplay = display2;
        this.nedt = new NewtEventDispatchThread(this.threadGroup, this.name);
        this.nedt.setDaemon(true);
    }

    public final Display getDisplay() {
        return this.swtDisplay;
    }

    @Override
    public long getPollPeriod() {
        return pollPeriod;
    }

    @Override
    public void setPollPeriod(long l) {
        pollPeriod = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Object object = this.edtLock;
        synchronized (object) {
            this.waitUntilStopped();
            if (DEBUG) {
                System.err.println(Thread.currentThread() + ": SWT-EDT reset - edt: " + this.nedt);
            }
            this.nedt = new NewtEventDispatchThread(this.threadGroup, this.name);
            this.nedt.setDaemon(true);
        }
    }

    private final void startImpl() {
        if (this.nedt.isAlive()) {
            throw new RuntimeException("SWT-EDT Thread.isAlive(): true, isRunning: " + this.nedt.isRunning() + ", edt: " + this.nedt);
        }
        ++this.start_iter;
        this.nedt.setName(this.name + this.start_iter);
        this.nedt.shouldStop = false;
        if (DEBUG) {
            System.err.println(Thread.currentThread() + ": SWT-EDT START - edt: " + this.nedt);
        }
        this.nedt.start();
    }

    @Override
    public boolean isCurrentThreadEDT() {
        return this.swtDisplay.getThread() == Thread.currentThread();
    }

    @Override
    public final boolean isCurrentThreadNEDT() {
        return this.nedt == Thread.currentThread();
    }

    @Override
    public final boolean isCurrentThreadEDTorNEDT() {
        Thread thread = Thread.currentThread();
        return thread == this.swtDisplay.getThread() || thread == this.nedt;
    }

    @Override
    public boolean isRunning() {
        return this.nedt.isRunning();
    }

    @Override
    public final void invokeStop(Runnable runnable) {
        this.invokeImpl(true, runnable, true);
    }

    @Override
    public final void invoke(boolean bl, Runnable runnable) {
        this.invokeImpl(bl, runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeImpl(boolean bl, Runnable runnable, boolean bl2) {
        Object object;
        Throwable throwable = null;
        RunnableTask runnableTask = null;
        Object object2 = object = new Object();
        synchronized (object2) {
            Object object3 = this.edtLock;
            synchronized (object3) {
                if (this.nedt.shouldStop) {
                    if (DEBUG) {
                        System.err.println(Thread.currentThread() + ": Warning: SWT-EDT about (1) to stop, won't enqueue new task: " + this.nedt);
                        Thread.dumpStack();
                    }
                    return;
                }
                if (bl2) {
                    Object object4 = this.nedt.sync;
                    synchronized (object4) {
                        this.nedt.shouldStop = true;
                        this.nedt.sync.notifyAll();
                    }
                    if (DEBUG) {
                        System.err.println(Thread.currentThread() + ": SWT-EDT signal STOP (on edt: " + this.isCurrentThreadEDT() + ") - " + this.nedt);
                    }
                } else if (!this.nedt.isRunning()) {
                    this.startImpl();
                }
                if (null == runnable) {
                    bl = false;
                } else if (this.isCurrentThreadEDT()) {
                    runnable.run();
                    bl = false;
                } else if (this.swtDisplay.isDisposed()) {
                    bl = false;
                } else {
                    runnableTask = new RunnableTask(runnable, bl ? object : null, true);
                    this.swtDisplay.asyncExec((Runnable)runnableTask);
                }
            }
            if (bl) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
                if (null == throwable) {
                    throwable = runnableTask.getThrowable();
                }
                if (null != throwable) {
                    if (throwable instanceof NativeWindowException) {
                        throw (NativeWindowException)throwable;
                    }
                    throw new RuntimeException(throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void waitUntilIdle() {
        NewtEventDispatchThread newtEventDispatchThread;
        Object object = this.edtLock;
        synchronized (object) {
            newtEventDispatchThread = this.nedt;
        }
        object = Thread.currentThread();
        if (!newtEventDispatchThread.isRunning() || newtEventDispatchThread == object || this.swtDisplay.getThread() == object) {
            return;
        }
        try {
            this.swtDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void waitUntilStopped() {
        Object object = this.edtLock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            if (this.nedt.isRunning() && this.nedt != thread && this.swtDisplay.getThread() != thread) {
                while (this.nedt.isRunning()) {
                    try {
                        this.edtLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }
    }

    class NewtEventDispatchThread
    extends Thread {
        volatile boolean shouldStop;
        volatile boolean isRunning;
        Object sync;

        public NewtEventDispatchThread(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
            this.shouldStop = false;
            this.isRunning = false;
            this.sync = new Object();
        }

        public final boolean isRunning() {
            return this.isRunning;
        }

        @Override
        public final void start() throws IllegalThreadStateException {
            this.isRunning = true;
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Object object;
            RuntimeException runtimeException;
            block34: {
                if (DEBUG) {
                    System.err.println(this.getName() + ": SWT-EDT run() START " + this.getName());
                }
                runtimeException = null;
                try {
                    do {
                        if (!this.shouldStop) {
                            if (!SWTEDTUtil.this.swtDisplay.isDisposed()) {
                                SWTEDTUtil.this.swtDisplay.syncExec(SWTEDTUtil.this.dispatchMessages);
                            } else {
                                SWTEDTUtil.this.dispatchMessages.run();
                            }
                        }
                        object = this.sync;
                        synchronized (object) {
                            if (!this.shouldStop) {
                                try {
                                    this.sync.wait(pollPeriod);
                                }
                                catch (InterruptedException interruptedException) {
                                    interruptedException.printStackTrace();
                                }
                            }
                        }
                    } while (!this.shouldStop);
                    if (!DEBUG) break block34;
                    System.err.println(this.getName() + ": SWT-EDT run() END " + this.getName() + ", " + runtimeException);
                }
                catch (Throwable throwable) {
                    block35: {
                        try {
                            this.shouldStop = true;
                            runtimeException = throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException("Within SWT-EDT", throwable);
                            if (!DEBUG) break block35;
                            System.err.println(this.getName() + ": SWT-EDT run() END " + this.getName() + ", " + runtimeException);
                        }
                        catch (Throwable throwable2) {
                            if (DEBUG) {
                                System.err.println(this.getName() + ": SWT-EDT run() END " + this.getName() + ", " + runtimeException);
                            }
                            Object object2 = SWTEDTUtil.this.edtLock;
                            synchronized (object2) {
                                boolean bl = this.isRunning = !this.shouldStop;
                                if (!this.isRunning) {
                                    SWTEDTUtil.this.edtLock.notifyAll();
                                }
                            }
                            if (DEBUG) {
                                System.err.println(this.getName() + ": SWT-EDT run() EXIT " + this.getName() + ", exception: " + runtimeException);
                            }
                            if (null != runtimeException) {
                                throw runtimeException;
                            }
                            throw throwable2;
                        }
                    }
                    Object object3 = SWTEDTUtil.this.edtLock;
                    synchronized (object3) {
                        boolean bl = this.isRunning = !this.shouldStop;
                        if (!this.isRunning) {
                            SWTEDTUtil.this.edtLock.notifyAll();
                        }
                    }
                    if (DEBUG) {
                        System.err.println(this.getName() + ": SWT-EDT run() EXIT " + this.getName() + ", exception: " + runtimeException);
                    }
                    if (null != runtimeException) {
                        throw runtimeException;
                    }
                }
            }
            object = SWTEDTUtil.this.edtLock;
            synchronized (object) {
                boolean bl = this.isRunning = !this.shouldStop;
                if (!this.isRunning) {
                    SWTEDTUtil.this.edtLock.notifyAll();
                }
            }
            if (DEBUG) {
                System.err.println(this.getName() + ": SWT-EDT run() EXIT " + this.getName() + ", exception: " + runtimeException);
            }
            if (null != runtimeException) {
                throw runtimeException;
            }
        }
    }
}

