#version 430 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;

layout (location = 0) in vec3 POSITION;
layout (location = 4) in vec2 TEXCOORD;

out vec3 wpos;
out vec2 uv;

void main()
{
	uv = TEXCOORD;
	wpos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
