#version 430 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
//uniform mat3 NormalMatrix;

layout (location = 0) in vec4 POSITION; // position
layout (location = 1) in vec4 NORMAL; // velocity

out float lit;
out float blur_lod;
out vec3 wpos;

void main()
{
	vec4 pos = vec4(POSITION.xyz, 1.0);
	wpos = vec3(ModelViewMatrix * pos);
	blur_lod = min(length(NORMAL.xyz)/2.0, 1.0) * 3.0;
	lit = max(1.0 - (length(wpos) / 128.0), 0.1);
	gl_PointSize = 16.0 * lit;
	gl_Position = ModelViewProjectionMatrix * pos;
}
