#version 430 core

uniform sampler2D particle;
uniform sampler1D decaylut;
uniform sampler2D depth;
uniform float viewport[2];

in vec3 wpos;
in float fade;

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_read_include.frag>

void main()
{
	vec2 uv_pos = gl_FragCoord.xy * vec2(viewport[0], viewport[1]);
	float d = (texture(depth, uv_pos).x - 0.5) * 2.0;
	vec3 pos = calc_position(uv_pos, d);

	//if ( pos.z > wpos.z ) discard;

	float alpha = clamp((wpos.z - pos.z)*5.0, 0.0, 1.0);
	vec4 part = texture(particle, gl_PointCoord.xy) * texture(decaylut, fade) * alpha;

	frag_color = part;
}
