#version 330 core

uniform sampler2D color_buffer;
uniform sampler2D ssao_buffer;
uniform sampler2D debug_buffer;

in vec2 uv;

layout (location = 0) out vec4 frag_color;

#include <post/blit_include.frag>

void main()
{
	vec2 uv2 = distort_uv(uv);
	vec4 c = texture(color_buffer, uv2);
	vec4 s = texture(ssao_buffer, uv2);
	vec4 color = vec4((c.rgb + s.rgb)*s.a, 1.0);
	color.a = c.a;
	frag_color = color_lookup(color, uv);
	//frag_color = vec4( s.a );
	//frag_color = vec4( s );
	
	//frag_color = texture(debug_buffer, uv)*0.5 + vec4(0.5); // mssao_x_normal_depth buffer
	//frag_color = vec4( texture(debug_buffer, uv).x ); // ao/count
	//frag_color = vec4( texture(debug_buffer, uv).y ); // ao
	//frag_color = vec4( texture(debug_buffer, uv).z ); // count
}
