#version 330 core

uniform sampler2D loading;
uniform vec2 params; // fade, loadingbar progress

in vec2 uv;

layout (location = 0) out vec4 frag_color;

void main()
{
	const float minX = 56.0/1280.0;
	const float maxX = 1187.0/1280.0;
	const float minY = 328.0/720.0;
	const float maxY = 394.0/720.0;

	vec4 texel = texture(loading, uv);
	if ( uv.x > minX && uv.x < maxX && uv.y > minY && uv.y < maxY )
	{
		float x = (uv.x - minX) / (maxX - minX);
		texel += vec4(x < params.y);
	}

	frag_color = texel * params.x;
}
