from itertools import product
from astar_hexgrid import AStarHexGrid, AStarHexGridNode
from collections import deque

def weapon2resource(weapon):
    if 'laser' == weapon:
        return 'R'
    elif 'droid' == weapon:
        return 'C'
    elif 'mortar' == weapon:
        return 'E'
    return None

def resource2weapon(resource):
    if 'R' == resource:
        return 'laser'
    elif 'C' == resource:
        return 'droid'
    elif 'E' == resource:
        return 'mortar'
    return None

class World:
    mapData = []
    resources = {}
    size_j = 0
    size_k = 0
    players = None
    graph = None
    nodes = None
    passable_tiles = ["G", "R", "E", "C"]
    directions = { 'up': [-1, -1], 'left-up': [0, -1], 'left-down': [1, 0], 'down': [1, 1], 'right-down': [0, 1], 'right-up': [-1, 0] }
    reverse_direction = {'up': 'down', 'left-up': 'right-down', 'left-down': 'right-up', 'down': 'up', 'right-down': 'left-up', 'right-up': 'left-down'}
    short_direction = {'up': 'U', 'left-up': 'LU', 'left-down': 'LD', 'down': 'D', 'right-down': 'RD', 'right-up': 'RU'}
    
    damage = { 'laser': [0, 16, 18, 22], 'mortar': [0, 20, 20, 25], 'droid': [0, 22, 24, 26] }
    aoe_damage = { 'laser': 0, 'mortar': 18, 'droid': 10 }
    kill_damage = 20
    kart = None

    def __init__(self, map_obj = {'data': [], 'j-length': 0, 'k-length': 0}):
        self.setMapData(map_obj)
        print "World has been created using map data with size {0}x{1}".format(self.size_j, self.size_k)
        
        # actionTiles[j][k]['actions'] = {'type': 'laser/mortar/droid/mine', 'damage': 0, killdamage: 0, 'playerIds': 0, 'moveVariables': {} }
        self.actionTiles = [[{'hasAction': 0, 'maxPoints': 0, 'actions': []} for k in range(self.size_k)] for j in range(self.size_j)]
        self.initialize_resources()

    def setMapData(self, map_obj):
        self.mapData = map_obj['data']
        self.size_k = map_obj['k-length']
        self.size_j = map_obj['j-length']

    def initialize_resources(self):
        self.resources['R'] = {}
        self.resources['C'] = {}
        self.resources['E'] = {}
        for j in range(0, self.size_j):
            for k in range(0, self.size_k):
                if self.mapData[j][k] == 'R':
                    self.resources['R'][(j,k)] = 2
                elif self.mapData[j][k] == 'C':
                    self.resources['C'][(j,k)] = 2
                elif self.mapData[j][k] == 'E':
                    self.resources['E'][(j,k)] = 2
    
    def tileType(self, tile):
        return self.mapData[tile[0]][tile[1]]

    def resourceCountForTile(self, tile):
        tileType = self.mapData[tile[0]][tile[1]]
        if (tuple(tile) in self.resources[tileType]):
            return self.resources[tileType][tuple(tile)]
        else:
            return 0

    def setPlayers(self, players):
        self.players = players

    def count_resources(self):
        laser_res = 0
        droid_res = 0
        mortar_res = 0
        for j in range(0, self.size_j):
            laser_res += self.mapData[j].count("R")
            droid_res += self.mapData[j].count("C")
            mortar_res += self.mapData[j].count("E")

        return {'laser': laser_res, 'droid': droid_res, 'mortar': mortar_res };

    def find_move_needed(self, start, end):
        for direction, offsets in self.directions.iteritems():
            if ((start[0] + offsets[0] == end[0]) and (start[1] + offsets[1] == end[1])):
                return direction

        return None

    def new_position_using_direction(self, position, direction):
        return [position[0] + self.directions[direction][0], position[1] + self.directions[direction][1]]

    def possible_moves(self, from_position, taken_tiles, spawnPassable = False):
        moves = []
        j = from_position[0]
        k = from_position[1]
        # Iterates over all possible directions
        for direction, offsets in self.directions.iteritems():
            jo = j + offsets[0]
            ko = k + offsets[1]

            # Check if the direction puts us outside map
            if (self.inside_map([jo, ko])):

                # Check if the direction puts us on top of another player
                if ([jo, ko] not in taken_tiles):

                    # Check if the direction puts us on a passable tile
                    if ((spawnPassable and self.mapData[jo][ko] == 'S') or self.passable_tile([jo, ko])):

                        # Add direction as possibility
                        moves.append(direction)

        return moves

    # TODO - populate resource tiles with apropriate actions
    def populate_action_tiles(self, enemies, me):
        self.actionTiles = [[{'hasAction': 0, 'actions': {}, 'damage': 0, 'minable': False, 'need': 0.0} for k in range(self.size_k)] for j in range(self.size_j)]
        spawnpoints = self.find_tiles("S")
        for enemy in enemies:
            if enemy['position'] not in spawnpoints and enemy['health'] > 0:
                self.calculate_enemy_action_tiles(enemy, enemies, me)
        for cluster in self.find_resource_clusters(me):
            self.calculate_cluster_action_tiles(cluster, me)
        

    def calculate_cluster_action_tiles(self, cluster, me):
        need = 0.0
        res = self.get_resources_in_cluster(cluster)
        for weapon, level in me['weapons'].iteritems():
            if level > 0 and level < 3:
                if res[weapon2resource(weapon)] >= self.players.resources_needed_to_level(me['name'], weapon):
                    need += 1.1
                elif res[weapon2resource(weapon)] > 0:
                    need += 0.4
        if 0 < need:
            for tile in cluster:
                self.action_tile_mineable(tile, need)

    def action_tile_mineable(self, tile, need):
        self.actionTiles[tile[0]][tile[1]]['minable'] = True
        self.actionTiles[tile[0]][tile[1]]['hasAction'] = 1
        self.actionTiles[tile[0]][tile[1]]['need'] = need

    # TODO - can lasers fire through multiple enemies?
    # TODO - hittign a rock or void tile with the mortar has no AoE damage
    def calculate_enemy_action_tiles(self, enemy, enemies ,me):
        non_laserable_tiles = ["O"]
        taken_tiles = [player['position'] for player in enemies]
        weapons = ('laser','mortar','droid')
        for weapon in weapons:
            if weapon == 'laser' and me['weapons'][weapon] > 0:
                damage = self.damage['laser'][me['weapons']['laser']]
                killdamage = 0
                if enemy['health'] <= damage:
                    killdamage = self.kill_damage
                
                for direction, offset in self.directions.iteritems():
                    moved = enemy['position']
                    enemies_hit = [enemy]
                    going = 1
                    while going:
                        moved = [moved[0]+offset[0],moved[1]+offset[1]]
                        if (not self.inside_map(moved)) or (self.mapData[moved[0]][moved[1]] in non_laserable_tiles):
                            going = 0
                            #print "lol"
                        elif self.mapData[moved[0]][moved[1]] == "V":
                            going += 1
                        elif moved in taken_tiles: # shooting the lazzar throuhg multilple enemies just adds up the score.
                            for player in enemies:
                                if player['position'] == moved:
                                    enemies_hit.append(player)
                                    if player['health'] <= damage:
                                        killdamage += self.kill_damage
                            going += 1
                                
                        else:
                            self.add_action_to_tile(moved, {'type': 'laser', 'damage': damage*len(enemies_hit)+killdamage, 'killdamage': killdamage, 'aoe': 0, 'players': enemies_hit, 'variables': {'direction': self.reverse_direction[direction]}})
                            #self.kart.hilightTile(moved,1)
                            going += 1
                        if going > me['weapons']['laser']+4:
                            going = 0

            
            if weapon == 'mortar' and me['weapons'][weapon] > 0:
                reachable = self.hexcircle(enemy['position'],1+me['weapons']['mortar'])
                for tile in reachable:
                    if self.passable_tile(tile) and tile not in taken_tiles:
                        damage = self.damage['mortar'][me['weapons']['mortar']]
                        killdamage = 0
                        if enemy['health'] <= damage:
                            killdamage = self.kill_damage

                        if self.tile_is_adjacent(tile, enemy['position']):
                            damage -= self.aoe_damage['mortar']
                            if me['health'] <= self.aoe_damage['mortar']:
                                damage -= 40
                            
                        self.add_action_to_tile(tile, {'type': 'mortar', 'damage': damage+killdamage, 'killdamage': killdamage, 'aoe': 0, 'players': [enemy], 'variables': {'target': enemy['position']}})
                        #self.kart.hilightTile(tile,1)
                        #self.kart.tileText(tile,'D')
                        
                       
                for direction, offset in self.directions.iteritems(): # AoE damage one tile from target
                    aoe_tile = [enemy['position'][0]+offset[0],enemy['position'][1]+offset[1]]
                    reachable = self.hexcircle(aoe_tile,1+me['weapons']['mortar'])
                    for tile in reachable:
                        if self.passable_tile(tile) and tile not in taken_tiles and self.inside_map(aoe_tile):
                            if self.mapData[aoe_tile[0]][aoe_tile[1]] not in ['V','O','S']:
                                damage = self.aoe_damage['mortar']
                                killdamage = 0
                                if enemy['health'] <= damage:
                                    killdamage = self.kill_damage
                                    
                                if self.tile_is_adjacent(tile, aoe_tile):
                                    damage -= self.aoe_damage['mortar']
                                    if me['health'] <= self.aoe_damage['mortar']:
                                        damage -= 40
                                    
                                self.add_action_to_tile(tile, {'type': 'mortar', 'damage': damage+killdamage, 'killdamage': killdamage, 'aoe': 1, 'players': [enemy], 'variables': {'target': aoe_tile}})
                                #self.kart.hilightTile(aoe_tile,1)
                                #self.kart.tileText(tile,'AoE')
                
                
            if weapon == 'droid' and me['weapons']['droid'] > 0:
                droid_passable_tiles = ["G", "R", "E", "S", "C"]
                self.calculate_enemy_action_tiles_droid(enemy['position'], enemy, enemies, me, 0)
                                    
                # TODO - crashed in game.. fix this:
                #    if self.mapData[tile[0]][tile[1]] in droid_passable_tiles:
                # IndexError: list index out of range
                for direction in self.directions: # AoE damage one tile from target
                    move = self.directions[direction]
                    tile = [enemy['position'][0]+move[0],enemy['position'][1]+move[1]]
                    if self.inside_map(tile):
                        if self.mapData[tile[0]][tile[1]] in droid_passable_tiles:
                            self.calculate_enemy_action_tiles_droid(tile, enemy, enemies, me, 1)
    
    # TODO - make sure droid action can end up on top of other enemy than the one beeing calculated
    # to ensure that AoE damage is calculated optimaly.
    def calculate_enemy_action_tiles_droid(self, tile, enemy, enemies, me, aoe):
        droid_passable_tiles = ["G", "R", "E", "S", "C"]
        ep = enemy['position']
        maxlen = me['weapons']['droid']+2
        
        if aoe == 1:
            damage = self.aoe_damage['droid']
        else:
            damage = self.damage['droid'][me['weapons']['droid']]
        
        killdamage = 0
        if enemy['health'] <= damage:
            killdamage = self.kill_damage
        
        #print "Max droid range: ", maxlen
        #print "Enemy: ", ep
        
        enemy_tiles = []
        for e in enemies:
            if e['position'] != ep:
                enemy_tiles.append(e['position'])
        

        openset = [{ 'position': tile, 'move': 'none', 'moves': 0, 'parent': None }]
        closedset = []
        while openset:
            n = openset.pop(0)
            
            if n['position'] == tile or self.mapData[n['position'][0]][n['position'][1]] in droid_passable_tiles and n['position'] != ep:
                #self.kart.hilightTile(n['position'],1)
                closedset.append(n)
                
                if n['moves'] < maxlen:
                
                    moves = self.possible_moves(n['position'], enemy_tiles)
                    for move in moves:
                        direction = self.directions[move]
                        newtile = [n['position'][0]+direction[0],n['position'][1]+direction[1]]
                        newn = { 'position': newtile, 'move': self.reverse_direction[move], 'moves': n['moves'] + 1, 'parent': n }
                        if newtile not in [ x['position'] for x in closedset] and newtile not in [ x['position'] for x in openset] and newtile not in enemy_tiles:
                            openset.append(newn)
                            #self.kart.tileText(newtile,str(newtile[0])+' / '+str(newtile[1]))

        closedset.pop(0)
        for n in closedset:
            moves = []
            p = n
            while p:
                if p['move'] != 'none':
                    moves.append(p['move'])
                
                p = p['parent']
            
            
            selfdamage = 0
            if self.tile_is_adjacent(tile, n['position']):
                selfdamage += self.aoe_damage['droid']
                if me['health'] <= self.aoe_damage['droid']:
                    selfdamage += 40
            
            #print "Tile: %i / %i - " % (n['position'][0],n['position'][1]), moves
            self.add_action_to_tile(n['position'], {'type': 'droid', 'damage': damage+killdamage-selfdamage, 'killdamage': killdamage, 'aoe': aoe, 'players': [enemy], 'variables': {'moves': moves, 'target': n['position']}})
                            
        #print "closed set: ",len(closedset)


    def add_action_to_tile (self, tile, action):
        
        # One laser action can only hit one target. no magic here.
        if action['type'] == 'laser':
            if 'laser' in self.actionTiles[tile[0]][tile[1]]['actions']:
                if self.actionTiles[tile[0]][tile[1]]['actions']['laser']['damage'] < action['damage']:
                    self.actionTiles[tile[0]][tile[1]]['actions']['laser'] = action
            else:
                self.actionTiles[tile[0]][tile[1]]['actions']['laser'] = action
        
        # Action sorting-wise, droid and mortar behave the same
        if action['type'] in ['droid','mortar']:
            if action['type'] in self.actionTiles[tile[0]][tile[1]]['actions']:
                if 'options' in self.actionTiles[tile[0]][tile[1]]['actions'][action['type']]:
                    new = 1
                    for option in self.actionTiles[tile[0]][tile[1]]['actions'][action['type']]['options']:
                        if option['variables'] == action['variables']:
                            new = 0
                            option['damage'] += action['damage']
                            option['killdamage'] += action['killdamage']
                            option['players'].append(action['players'])
                    if new == 1:
                        self.actionTiles[tile[0]][tile[1]]['actions'][action['type']]['options'].append(action)
                    
            else:
                self.actionTiles[tile[0]][tile[1]]['actions'][action['type']] = {}
                self.actionTiles[tile[0]][tile[1]]['actions'][action['type']]['options'] = [action]
            
            maxdmg = 0
            for option in self.actionTiles[tile[0]][tile[1]]['actions'][action['type']]['options']:
                if option['damage'] > maxdmg:
                    maxdmg = option['damage']
                    
            self.actionTiles[tile[0]][tile[1]]['actions'][action['type']]['damage'] = maxdmg
        
        maxdmg = 0
        for act_name, act in self.actionTiles[tile[0]][tile[1]]['actions'].iteritems():
            if act['damage'] > maxdmg:
                maxdmg = act['damage']
                self.actionTiles[tile[0]][tile[1]]['damage'] = act['damage']
                self.actionTiles[tile[0]][tile[1]]['best_action'] = act_name
        
        
        self.actionTiles[tile[0]][tile[1]]['hasAction'] = 1
    
    def find_best_closes_actiontile(self, me):
        scope = self.hexcircle(me['position'],2) # two moves, since the last move is weaponsfire
        
        for tile in scope:
            #self.kart.hilightTile(tile,1)
            pass
    
    def calculate_stranger_danger(self):
        
        nextmove_factor = 0.3
        
        self.strangerDanger = [[0.0 for k in range(self.size_k)] for j in range(self.size_j)]
        self.enemyDanger = {}
        for enemy in self.players.enemies():
            self.enemyDanger[enemy['name']] = [[0.0 for k in range(self.size_k)] for j in range(self.size_j)]
    
        for enemy in self.players.enemies():
            enemy_positions = self.player_2move_tiles(enemy['position'])
            
            if enemy['weapons']['laser'] > 0:
                damage = float(self.damage['laser'][enemy['weapons']['laser']])*1.4
                self.calculate_stranger_danger_laser(enemy['name'],enemy['position'],enemy['weapons']['laser']+4,damage)
                for movetile in enemy_positions:
                    damage = float(self.damage['laser'][enemy['weapons']['laser']])
                    if movetile['move'] == 1:
                        damage = damage*1.2
                    self.calculate_stranger_danger_laser(enemy['name'],movetile['tile'],enemy['weapons']['laser']+4,damage)
                    
                    
            if enemy['weapons']['mortar'] > 0:
                damage = float(self.damage['mortar'][enemy['weapons']['mortar']])*1.4
                mortar_range = enemy['weapons']['mortar']+1
                self.calculate_stranger_danger_mortar(enemy['name'],enemy['position'],mortar_range,damage)
                
                damage = float(self.aoe_damage['mortar'])*1.4
                mortar_range = enemy['weapons']['mortar']+2
                self.calculate_stranger_danger_mortar(enemy['name'],enemy['position'],mortar_range,damage)
        
                for movetile in enemy_positions:
                    damage = float(self.damage['mortar'][enemy['weapons']['mortar']])
                    if movetile['move'] == 1:
                        damage = damage*1.2
                    mortar_range = enemy['weapons']['mortar']+1
                    self.calculate_stranger_danger_mortar(enemy['name'],movetile['tile'],mortar_range,damage)
                    
                    damage = float(self.aoe_damage['mortar'])
                    if movetile['move'] == 1:
                        damage = damage*1.2
                    mortar_range = enemy['weapons']['mortar']+2
                    self.calculate_stranger_danger_mortar(enemy['name'],movetile['tile'],mortar_range,damage)
        
            if enemy['weapons']['droid'] > 0:
                damage = float(self.damage['droid'][enemy['weapons']['droid']])*1.4
                droid_range = enemy['weapons']['droid']+1
                self.calculate_stranger_danger_droid(enemy['name'],enemy['position'],droid_range,damage)
                
                damage = float(self.aoe_damage['droid'])*1.4
                droid_range = enemy['weapons']['droid']+2
                self.calculate_stranger_danger_droid(enemy['name'],enemy['position'],droid_range,damage)
        
                for movetile in enemy_positions:
                    damage = float(self.damage['droid'][enemy['weapons']['droid']])
                    if movetile['move'] == 1:
                        damage = damage*1.2
                    droid_range = enemy['weapons']['droid']+1
                    self.calculate_stranger_danger_droid(enemy['name'],movetile['tile'],droid_range,damage)
                    
                    damage = float(self.aoe_damage['droid'])
                    if movetile['move'] == 1:
                        damage = damage*1.2
                    droid_range = enemy['weapons']['droid']+2
                    self.calculate_stranger_danger_droid(enemy['name'],movetile['tile'],droid_range,damage)
        
        for j in range(self.size_j):
            for k in range(self.size_k):
                for enemy in self.players.enemies():
                    self.strangerDanger[j][k] += self.enemyDanger[enemy['name']][j][k]
            
            
    def calculate_stranger_danger_laser(self, enemy_name, tile, laser_range, damage):
        for direction, offset in self.directions.iteritems():
            for i in range(1,laser_range+1):
                pos = [tile[0]+offset[0]*i,tile[1]+offset[1]*i]
                if not self.inside_map(pos) or self.mapData[pos[0]][pos[1]] == "O":
                    break
                self.enemyDanger[enemy_name][pos[0]][pos[1]] = max(self.enemyDanger[enemy_name][pos[0]][pos[1]], damage)
    
    def calculate_stranger_danger_mortar(self, enemy_name, tile, mortar_range, damage):
        area = self.hexcircle(tile,mortar_range)
        for tile in area:
            if self.inside_map(tile):
                if self.mapData[tile[0]][tile[1]] in self.passable_tiles:
                    self.enemyDanger[enemy_name][tile[0]][tile[1]] = max(self.enemyDanger[enemy_name][tile[0]][tile[1]], damage)
    
    def calculate_stranger_danger_droid(self, enemy_name, tile, droid_range, damage):
        droid_passable_tiles = ["G", "R", "E", "C"]        
        openset = [{ 'position': tile, 'moves': 0 }]
        closedset = []
        while openset:
            n = openset.pop(0)
            if n['position'] == tile or self.mapData[n['position'][0]][n['position'][1]] in droid_passable_tiles:
                #self.kart.hilightTile(n['position'],1)
                closedset.append(n)
                
                if n['moves'] < droid_range:
                
                    moves = self.possible_moves(n['position'],[])
                    for move in moves:
                        direction = self.directions[move]
                        newtile = [n['position'][0]+direction[0],n['position'][1]+direction[1]]
                        newn = { 'position': newtile, 'moves': n['moves'] + 1, }
                        if newtile not in [ x['position'] for x in closedset] and newtile not in [ x['position'] for x in openset]:
                            openset.append(newn)
                            #self.kart.tileText(newtile,str(newtile[0])+' / '+str(newtile[1]))
        closedset.pop(0)

        for i in closedset:
            self.enemyDanger[enemy_name][i['position'][0]][i['position'][1]] = max(self.enemyDanger[enemy_name][i['position'][0]][i['position'][1]], damage)
    
    # "flood fill" 2 moves out from player
    def player_2move_tiles(self, tile):
        tiles = []
        for move, offset in self.directions.iteritems():
            newtile = [tile[0]+offset[0],tile[1]+offset[1]]
            if self.passable_tile(newtile, self.players.allplayers()):
                tiles.append({'tile': newtile, 'move': 1})
                for move2, offset2 in self.directions.iteritems():
                    newtile2 = [newtile[0]+offset2[0],newtile[1]+offset2[1]]
                    if self.passable_tile(newtile2, self.players.allplayers()):
                        if newtile2 not in tiles:
                            tiles.append({'tile': newtile2, 'move': 2})
        return tiles
                    
    
    def loadout_analyzer(self):
        if self.loadout_analyzer_spawnpoints_connected():
            spawnpoints = self.find_tiles("S")
            reachable = self.available_tiles(spawnpoints[0],[])
            
            grass = len(reachable)
            
            rocks = 0
            for j in range(self.size_j):
                for k in range(self.size_k):
                    if self.mapData[j][k] == "O":
                        rocks += 1
            
            #print "Grass: ", grass, " Rocks: ", rocks
            
            rock_percent = (float(rocks)/(float(rocks)+float(grass)))*100
            #print "Rock percent: ", rock_percent
            
            if rock_percent > 50.0:
                return ['mortar','droid']
            
            # E for mortar, R for lazar, C for droid
            resources = {'E': 0, 'R': 0, 'C': 0}
            
            for tile in reachable:
                for resource, num in resources.iteritems():
                    if self.mapData[tile[0]][tile[1]] == resource:
                        resources[resource] += 2
            
            #print "resources: ", resources
            
            upgrades = {'E': 1, 'R': 1, 'C': 1}
            for resource, num in resources.iteritems():
                if num >= 4+5:
                    upgrades[resource] = 3
                elif num >= 4:
                    upgrades[resource] = 3
            
            lvls = {'laser': upgrades['R'], 'mortar': upgrades['E'], 'droid': upgrades['C']}
            #print "weapon levels: ", lvls
            
            if lvls['droid'] == 3:
                return ['droid','laser']
            else:
                return ['mortar','laser']
            
        else: # droid is useless if spawnpoints are unreachable
            return ['laser','mortar']
        
    def loadout_analyzer_spawnpoints_connected (self):
        spawnpoints = self.find_tiles("S")
        for n in range(1, len(spawnpoints)):
            if not self.search(spawnpoints[0], spawnpoints[n], [], True):
                return False
        return True
    
    def find_resource_clusters(self, me):
        # E for mortar, R for lazar, C for droid
        resource_types = {'mortar': 'E', 'laser': 'R', 'droid': 'C'}
        tile_types = []
        for weapon, lvl in me['weapons'].iteritems():
            if lvl > 0 and lvl < 3:
                tile_types.append(resource_types[weapon])
        
        resource_tiles = self.find_tiles(tile_types)
        reachable = self.available_tiles(me['position'], tile_types) 

        for tile in resource_tiles[:]: # remove unreachable tiles
            if tile not in reachable:
                resource_tiles.remove(tile)
        
        if(len(resource_tiles) == 0):
            print "No resources left..."
            return []
        
        clusters = []
        cluster_tiles_open = []
        
        n = resource_tiles.pop()
        cluster_tiles_open.append(n)
        cluster_tiles = []
        
        while resource_tiles:
            
            if len(cluster_tiles_open) > 0:
                n = cluster_tiles_open.pop()
                cluster_tiles.append(n)
            else:
                clusters.append(cluster_tiles)
                n = resource_tiles.pop()
                cluster_tiles_open = [n]
                cluster_tiles = []                
            
            circle = self.hexcircle(n,2)
            for pos in circle:
                if pos in resource_tiles:
                    
                    resource_tiles.pop(resource_tiles.index(pos))
                    cluster_tiles_open.append(pos)
        
        clusters.append(cluster_tiles_open)
        
        return clusters
        
        
    def find_tiles(self, tiletypes):
        if type(tiletypes) is str:
            tiletypes = [tiletypes]
        tiles = []
        for j in range(self.size_j):
            for k in range(self.size_k):
                if self.mapData[j][k] in tiletypes:
                    tiles.append([j,k])
        return tiles
    
    def get_resources_in_cluster(self, cluster):
        ret = {}
        ret['R'] = 0
        ret['C'] = 0
        ret['E'] = 0
        for pos in cluster:
            p = tuple(pos)
            for res in self.resources:
                if (p in self.resources[res]):
                    ret[res] += self.resources[res][p]
        return ret

    def tile_is_adjacent(self,tile,target):
        diff = [tile[0]-target[0],tile[1]-target[1]]
        for move, offset in self.directions.iteritems():
            if diff == offset:
                return True
        return False

    def passable_tile(self, tile, enemies = None):
        if(self.inside_map(tile)):
            if enemies:
                if (self.mapData[tile[0]][tile[1]] in self.passable_tiles):
                    for enemy in enemies:
                        if enemy['position'] == tile:
                            return False
                    return True
                else:
                    return False
            else:
                return (self.mapData[tile[0]][tile[1]] in self.passable_tiles)
        else:
            return False

    def inside_map(self, tile):
        return ((0 <= tile[0] < self.size_j) and (0 <= tile[1] < self.size_k))

    def hexcircle(self, position, radius):
        tiles = []
        movement_dir = {"up": "right-down", "right-up": "down", "right-down": "left-down", "down": "left-up", "left-down": "up", "left-up": "right-up"}

        for r in range(radius + 1):
            for direction, offsets in self.directions.iteritems():
                corner = [position[0] + (offsets[0] * r), position[1] + (offsets[1] * r)]
                for i in range(r):
                    o = self.directions[movement_dir[direction]]
                    tile = [corner[0] + (o[0] * i), corner[1] + (o[1] * i)]
                    if(self.inside_map(tile)):
                        tiles.append(tile)
        
        return tiles


    def available_tiles(self, position, taken_tiles):
        #print "Finding all available tiles from position {0}".format(position)
        available_tiles = []
        q = [position]
        while q:
            n = q.pop()
            available_tiles.append(n)
            moves = self.possible_moves(n, taken_tiles)
            for move in moves:
                target = [n[0] + self.directions[move][0], n[1] + self.directions[move][1]]
                if (target not in available_tiles and target not in q):
                    q.append(target)

        return available_tiles

    def update(self, map_obj = None):
        if(map_obj != None):
            self.setMapData(map_obj)
            
        self.graph = None
        self.nodes = None

    def create_graph(self, taken_tiles, spawnPassable):
        nodes = [[AStarHexGridNode(j, k) for k in range(self.size_k)] for j in range(self.size_j)]  
        graph = {}
        for j, k in product(range(self.size_j), range(self.size_k)):
            node = nodes[j][k]
            graph[node] = []
            moves = self.possible_moves([j, k], taken_tiles, spawnPassable)
            for move in moves:
                target_j = j + self.directions[move][0]
                target_k = k + self.directions[move][1]
                graph[node].append(nodes[target_j][target_k])

        return graph, nodes

    def search(self, start, end, takenTiles = [], spawnPassable = False):
        if (end == None):
            return []

        if (start == end):
            return []

        if(self.graph == None or self.nodes == None):
            takenTiles = [tile for tile in takenTiles if tile != end]
            self.graph, self.nodes = self.create_graph(takenTiles, spawnPassable)

        # Removes the end tile from takenTiles so its possible to find path if enemy player specified
        paths = AStarHexGrid(self.graph)
        start, end = self.nodes[start[0]][start[1]], self.nodes[end[0]][end[1]]
        path = paths.search(start, end)

        if path is None:
            return None

        # Convert found path to sequence of coordinates
        path = [[tile.j, tile.k] for tile in path]

        # Remove first tile since this is our starting point and is not needed
        return path[1::]
    
    def moveActionsForPath(self, path):
        if (path == None):
            return None
        return [{'action': 'move', 'tile': tile} for tile in path]

    def setMapwindow(self, mapwindow):
        self.kart = mapwindow

    def giveCircle(self, pos, radius):
        # Add checks to see if tile exists
        tiles = []
        for i in range(0,radius+1):
            tiles.append((pos[0]+radius, pos[1]+i))
            tiles.append((pos[0]+radius-i, pos[1]+radius))
            tiles.append((pos[0]-i, pos[1]+radius-i))
            tiles.append((pos[0]-radius, pos[1]-i))
            tiles.append((pos[0]-radius+i, pos[1]-radius))
            tiles.append((pos[0]+i, pos[1]-radius+i))
        return tiles
