package skyport.enums;

import java.util.HashMap;
import java.util.Map;


public class TileFactory {

	private static final TileFactory instance = new TileFactory();
	
	private Map<Character, Tile> map;
	
	private TileFactory() {
		map = new HashMap<Character, Tile>();
		
		for (Tile tile : Tile.values()) {
			map.put(tile.toChar(), tile);
		}
	}
	
	public Tile getByChar(char c) {
		return map.get(c);
	}
	
	public Tile[][] convertTo2DTileArray(char[][] data) {
		Tile[][] tiles = new Tile[data.length][data[0].length];

		for (int i = 0; i < data.length; ++i) {
			for (int j = 0; j < data[i].length; ++j) {
				tiles[i][j] = getByChar(data[i][j]);
			}
		}

		return tiles;
	}
	
	public static TileFactory getInstance() {
		return instance;
	}
}
