package skyport;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import skyport.constants.GameConstants;
import skyport.enums.Tile;
import skyport.json.PlayerBean;

public class Resources {

	private int[][] resourceCount;
	private Map<String, PlayerResources> playerResources;

	public Resources(final Tile[][] tileMap, final List<PlayerBean> players) {
		playerResources = new HashMap<String, PlayerResources>();

		for (PlayerBean player : players) {
			String playerName = player.getName();
			playerResources.put(playerName, new PlayerResources());
		}

		int jlength = tileMap.length;
		int klength = tileMap[0].length;
		resourceCount = new int[jlength][klength];

		for (int i = 0; i < jlength; ++i) {
			for (int j = 0; j < klength; ++j) {
				if (tileMap[i][j].isMineable()) {
					resourceCount[i][j] = GameConstants.ORIGINAL_RESOURCE_MINE_COUNT;
				}
			}
		}
	}

	public int getResourceCountAt(final Coordinate coord) {
		return resourceCount[coord.getX()][coord.getY()];
	}
	
	public void decrementResourceCountAt(final Coordinate coord) {
		--resourceCount[coord.getX()][coord.getY()];
	}
	
	public PlayerResources getPlayerResources(final String playerName) {
		return playerResources.get(playerName);
	}
}
