/*
 * Decompiled with CFR 0.152.
 */
package skyport.algorithms.astar;

import java.util.HashSet;
import java.util.LinkedList;
import skyport.algorithms.astar.Node;

public class AStar {
    private static final int COST = 1;

    private static int estimateDistance(Node node1, Node node2) {
        return Math.abs(node1.getX() - node2.getX()) + Math.abs(node1.getY() - node2.getY());
    }

    static LinkedList<Node> findRoute(Node start, Node goal) {
        boolean foundAPath = false;
        HashSet<Node> closedSet = new HashSet<Node>();
        HashSet<Node> openSet = new HashSet<Node>();
        openSet.add(start);
        start.setG(0);
        start.setF(AStar.estimateDistance(start, goal));
        while (!openSet.isEmpty() && !foundAPath) {
            Node current = null;
            for (Node node : openSet) {
                if (current != null && node.getF() >= current.getF()) continue;
                current = node;
            }
            boolean bl = foundAPath = current == goal;
            if (foundAPath) continue;
            openSet.remove(current);
            closedSet.add(current);
            for (Node neighbor : current.getNeighbors()) {
                boolean isInOpenSet = openSet.contains(neighbor);
                int tentativeG = current.getG() + 1;
                if ((isInOpenSet || closedSet.contains(neighbor)) && tentativeG >= neighbor.getG()) continue;
                neighbor.setCameFrom(current);
                neighbor.setG(tentativeG);
                neighbor.setF(neighbor.getG() + AStar.estimateDistance(neighbor, goal));
                if (isInOpenSet) continue;
                openSet.add(neighbor);
            }
        }
        if (foundAPath) {
            LinkedList<Node> nodes = new LinkedList<Node>();
            Node current = goal;
            while (current.getCameFrom() != null) {
                nodes.addFirst(current);
                current = current.getCameFrom();
            }
            return nodes;
        }
        return null;
    }
}

