/*
 * Decompiled with CFR 0.152.
 */
package skyport.ais;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import skyport.Coordinate;
import skyport.Game;
import skyport.SkyportException;
import skyport.algorithms.astar.Node;
import skyport.connection.TcpClient;
import skyport.constants.GameConstants;
import skyport.enums.Direction;
import skyport.enums.DirectionFactory;
import skyport.enums.Tile;
import skyport.enums.WeaponType;
import skyport.enums.WeaponTypeFactory;
import skyport.json.JsonMessage;
import skyport.json.MapBean;
import skyport.json.PlayerBean;
import skyport.json.WeaponBean;

public abstract class Ai {
    private String ip = "127.0.0.1";
    private int port = 54321;
    protected Game game = new Game();
    protected JsonMessage message = new JsonMessage();
    protected String aiName;
    protected TcpClient client;

    public Ai(String aiName) {
        this.aiName = aiName;
        this.client = null;
    }

    protected abstract void processTurn() throws JsonProcessingException;

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    private void handshake() throws IOException, SkyportException {
        Boolean status;
        this.client.send(this.message.handshake(this.aiName));
        String fromServer = this.client.receive();
        Map<String, Object> map = this.message.getMap(fromServer);
        if ("connect".equals(map.get("message")) && ((status = (Boolean)map.get("status")) == null || !status.booleanValue())) {
            throw new SkyportException("Connection refused by server");
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public void start() throws IOException, SkyportException {
        socket = new Socket(this.ip, this.port);
        this.client = new TcpClient(socket);
        System.out.println("connected to " + this.ip + ":" + this.port);
        this.handshake();
        fromServer = this.client.receive();
        initialGamestate = this.message.getMap(fromServer);
        if ("gamestate".equals((String)initialGamestate.get("message"))) {
            players = (List)initialGamestate.get("players");
            mapBean = (MapBean)initialGamestate.get("map");
            this.game.initialize(mapBean, players);
        }
        this.client.send(this.message.loadout());
        fromServer = this.client.receive();
        System.out.println(this.aiName);
        while (fromServer != null) {
            start = System.currentTimeMillis();
            gamestate = this.message.getMap(fromServer);
            messageType = (String)gamestate.get("message");
            if (messageType == null) ** GOTO lbl82
            var8_9 = messageType;
            tmp = -1;
            switch (var8_9.hashCode()) {
                case -1606278184: {
                    if (!var8_9.equals("endturn")) break;
                    tmp = 1;
                    break;
                }
                case -1422950858: {
                    if (!var8_9.equals("action")) break;
                    tmp = 2;
                    break;
                }
                case 1019617247: {
                    if (!var8_9.equals("gamestate")) break;
                    tmp = 3;
                    break;
                }
            }
            switch (tmp) {
                case 3: {
                    this.game.setTurn((Integer)gamestate.get("turn"));
                    players = (List)gamestate.get("players");
                    this.game.setPlayers(players);
                    mapBean = (MapBean)gamestate.get("map");
                    this.game.updateMap(mapBean);
                    currentPlayer = this.game.getCurrentPlayer();
                    if (this.aiName.equals(currentPlayer.getName())) {
                        this.processTurn();
                        end = System.currentTimeMillis();
                        System.out.println("Calculation time: " + (end - start) + " ms");
                        break;
                    }
                    System.out.println("waiting");
                    break;
                }
                case 2: {
                    actionAiName = (String)gamestate.get("from");
                    actionType = (String)gamestate.get("type");
                    player = this.game.getPlayerByName(actionAiName);
                    pos = player.getPosition();
                    if (actionAiName.equals(this.aiName)) break;
                    if ("mine".equals(actionType)) {
                        tileAtPos = this.game.getTilemap().getTileAt(pos);
                        if (tileAtPos != null && tileAtPos.isMineable()) {
                            resources = this.game.getResources();
                            resources.getPlayerResources(actionAiName).incrementResourceCount(tileAtPos);
                            resources.decrementResourceCountAt(pos);
                            System.out.println(String.valueOf(actionAiName) + " mined " + tileAtPos.toString());
                            break;
                        }
                        System.out.println("A player mined a non-minable tile!");
                        break;
                    }
                    if ("move".equals(actionType)) {
                        actionDir = (String)gamestate.get("direction");
                        dir = DirectionFactory.getInstance().getByString(actionDir);
                        pos.changeToCoordinateInDirection(dir);
                        break;
                    }
                    if ("upgrade".equals(actionType)) {
                        actionWeapon = (String)gamestate.get("weapon");
                        weaponType = WeaponTypeFactory.getInstance().getByString(actionWeapon);
                        weapon = player.getPrimaryWeapon().getType() == weaponType ? player.getPrimaryWeapon() : player.getSecondaryWeapon();
                        this.game.getResources().getPlayerResources(actionAiName).upgradeWeapon(weapon);
                        break;
                    }
                    System.out.println(fromServer);
                    break;
                }
                default: {
                    System.out.println(fromServer);
                    break;
                }
lbl82:
                // 1 sources

                System.out.println(fromServer);
                break;
                case 1: 
            }
            fromServer = this.client.receive();
        }
    }

    protected Direction getSafeDirectionFrom(Coordinate pos) {
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Direction dir = directionArray[n2];
            Coordinate adjacentPos = pos.getCoordinateInDirection(dir);
            Tile tile = this.game.getTilemap().getTileAt(adjacentPos);
            if (tile != null && tile.isTraversable() && !this.game.opponentAt(adjacentPos)) {
                return dir;
            }
            ++n2;
        }
        return null;
    }

    protected List<Direction> getDirectionsFrom(Coordinate from, List<Node> nodes) {
        ArrayList<Direction> sequence = new ArrayList<Direction>();
        Coordinate current = from;
        for (Node node : nodes) {
            Coordinate next = new Coordinate(node.getX(), node.getY());
            Direction dir = current.getDirectionTowards(next);
            sequence.add(dir);
            current = next;
        }
        return sequence;
    }

    protected List<Direction> getDirectionSequenceTowards(int moves, Coordinate from, Coordinate to) {
        List<Node> nodes = this.game.getNodemap().getRoute(from, to);
        if (nodes == null) {
            return null;
        }
        return this.getDirectionsFrom(from, nodes);
    }

    protected List<Direction> getDirectionSequence(int maxMoves, Coordinate from, Coordinate to) {
        List<Node> nodes = this.game.getNodemap().getRoute(from, to);
        if (nodes == null || nodes.size() > maxMoves) {
            return null;
        }
        return this.getDirectionsFrom(from, nodes);
    }

    protected WeaponBean[] weaponsSortedByDamage(PlayerBean player) {
        WeaponBean[] weapons = new WeaponBean[]{player.getPrimaryWeapon(), player.getSecondaryWeapon()};
        int[] damages = new int[weapons.length];
        int i = 0;
        while (i < weapons.length) {
            WeaponType weaponType = weapons[i].getType();
            int level = weapons[i].getLevel();
            switch (weaponType) {
                case DROID: {
                    damages[i] = GameConstants.DROID_DAMAGE[level - 1];
                    break;
                }
                case LASER: {
                    damages[i] = GameConstants.LASER_DAMAGE[level - 1];
                    break;
                }
                case MORTAR: {
                    damages[i] = GameConstants.MORTAR_DAMAGE[level - 1];
                    break;
                }
            }
            ++i;
        }
        if (damages[1] > damages[0]) {
            WeaponBean temp = weapons[0];
            weapons[0] = weapons[1];
            weapons[1] = temp;
        }
        return weapons;
    }
}

