/*
 * Decompiled with CFR 0.152.
 */
package skyport;

import skyport.enums.Direction;

public class Coordinate {
    private int x;
    private int y;

    public Coordinate(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Coordinate(Coordinate other) {
        this.x = other.x;
        this.y = other.y;
    }

    public Coordinate(String string) {
        String[] items = string.split(",");
        try {
            this.x = Integer.parseInt(items[0].trim());
            this.y = Integer.parseInt(items[1].trim());
        }
        catch (Exception e) {
            this.x = -1;
            this.y = -1;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void changeToCoordinateInDirection(Direction dir) {
        switch (dir) {
            case LEFT_DOWN: {
                ++this.x;
                break;
            }
            case DOWN: {
                ++this.x;
            }
            case RIGHT_DOWN: {
                ++this.y;
                break;
            }
            case RIGHT_UP: {
                --this.x;
                break;
            }
            case UP: {
                --this.x;
            }
            case LEFT_UP: {
                --this.y;
                break;
            }
        }
    }

    public Coordinate getCoordinateInDirection(Direction dir) {
        return this.getCoordinateInDirection(dir, 1);
    }

    public Coordinate getCoordinateInDirection(Direction dir, int range) {
        int newX = this.x;
        int newY = this.y;
        switch (dir) {
            case LEFT_DOWN: {
                newX += range;
                break;
            }
            case DOWN: {
                newX += range;
            }
            case RIGHT_DOWN: {
                newY += range;
                break;
            }
            case RIGHT_UP: {
                newX -= range;
                break;
            }
            case UP: {
                newX -= range;
            }
            case LEFT_UP: {
                newY -= range;
                break;
            }
        }
        return new Coordinate(newX, newY);
    }

    public Coordinate getRelativeCoordinateTo(Coordinate coord) {
        int diffX = coord.x - this.x;
        int diffY = coord.y - this.y;
        return new Coordinate(diffX, diffY);
    }

    public Direction getDirectionTowards(Coordinate coord) {
        int factor;
        int diffX = coord.x - this.x;
        int diffY = coord.y - this.y;
        int n = factor = diffX != 0 ? Math.abs(diffX) : Math.abs(diffY);
        if (factor != 0) {
            diffX /= factor;
            diffY /= factor;
        }
        if (diffX == -1) {
            if (diffY == -1) {
                return Direction.UP;
            }
            if (diffY == 0) {
                return Direction.RIGHT_UP;
            }
        } else if (diffX == 0) {
            if (diffY == -1) {
                return Direction.LEFT_UP;
            }
            if (diffY == 1) {
                return Direction.RIGHT_DOWN;
            }
        } else if (diffX == 1) {
            if (diffY == 0) {
                return Direction.LEFT_DOWN;
            }
            if (diffY == 1) {
                return Direction.DOWN;
            }
        }
        return null;
    }

    public boolean hasDirectRangeTo(Coordinate coord, int range) {
        int distance;
        Direction dir = this.getDirectionTowards(coord);
        if (dir == null) {
            return false;
        }
        switch (dir) {
            case UP: 
            case RIGHT_UP: 
            case DOWN: 
            case LEFT_DOWN: {
                distance = Math.abs(coord.x - this.x);
                break;
            }
            case RIGHT_DOWN: 
            case LEFT_UP: {
                distance = Math.abs(coord.y - this.y);
                break;
            }
            default: {
                distance = Integer.MAX_VALUE;
            }
        }
        return range >= distance;
    }

    public boolean hasRangeTo(Coordinate coord, int range) {
        boolean withinRange = false;
        int x1 = this.x - range;
        int x2 = this.x + range;
        int currentX = x1;
        while (currentX <= x2 && !withinRange) {
            if (currentX == coord.x) {
                int diffX = this.x - currentX;
                int y1 = this.y - range - (diffX > 0 ? 0 : diffX);
                int y2 = this.y + range - (diffX < 0 ? 0 : diffX);
                int currentY = y1;
                while (currentY <= y2 && !withinRange) {
                    withinRange = currentY == coord.y;
                    ++currentY;
                }
            }
            ++currentX;
        }
        return withinRange;
    }

    public String getString() {
        return String.valueOf(this.x) + "," + this.y;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Coordinate other = (Coordinate)obj;
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }
}

