#!/usr/bin/env python2

# based on the simplewalker.py ai

import sys
import random
import socket
import math
import Queue
from socket import timeout
import json
import skyals

assert(len(sys.argv) == 2)

# We open the socket manually
sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
sock.connect(('127.0.0.1', 54321))

inputbuf = "" # All received data goes in here
weapons_chosen = [] # remember the weapons we chose in the loadout

p = [0,0]
ress = [0,0,0]
levels = [0,0,0]
lastMined = 0
X = 0
Y = 0
dirEne = 0
moDiffX = 0
moDiffY = 0
bestDir = 0

def read_packet(): # this AI takes a single-thread blocking-I/O approach
    global inputbuf
    try:
        ret = sock.recv(1)
        inputbuf += ret
        if not ret:
            print("Disconnected!")
            sys.exit(1)
    except socket.timeout as e:
        print("timeout!")
        return None
    except socket.error as e:
        print("error: %s" % e)
        sys.exit(1)
    try:
        characters_to_read = inputbuf.index("\n")
        line = inputbuf[0:characters_to_read] # removing the newline
        inputbuf = inputbuf[characters_to_read+1:len(inputbuf)]
        return line
    except ValueError as f:
        return None


def outside_map(a,b):
    global X, Y
    if((a+1 > X) or (a < 0) or (b+1 > Y) or (b < 0)):
	return True
    else:
        return False

def is_hitable_laser(board,a,b):
    global p, dirEne
    for i in range(1,6+levels[1]): #up
        x = p[0]-i
	y = p[1]-i
	if(outside_map(x,y) or (board[x][y] == 'O')):
	    break
	if(x == a) and (y == b):
	    dirEne = 0
	    return True
    for i in range(1,6+levels[1]): #down
    	x = p[0]+i
	y = p[1]+i
	if(outside_map(x,y) or(board[x][y] == 'O')):
	    break
	if(x == a)  and (y == b):
	    dirEne = 1
	    return True
    for i in range(1,6+levels[1]): #right-up
    	x = p[0]-i
	y = p[1]
	if(outside_map(x,y) or(board[x][y] == 'O')):
	    break
	if(x == a)  and (y == b):
	    dirEne = 2
	    return True
    for i in range(1,6+levels[1]): #right-down
    	x = p[0]
	y = p[1]+i
	if(outside_map(x,y) or(board[x][y] == 'O')):
	    break
	if(x == a)  and (y == b):
	    dirEne = 3
	    return True
    for i in range(1,6+levels[1]): #left-up
    	x = p[0]
	y = p[1]-i
	if(outside_map(x,y) or(board[x][y] == 'O')):
	    break
	if(x == a)  and (y == b):
	    dirEne = 4
	    return True
    for i in range(1,6+levels[1]): #left-down
    	x = p[0]+i
	y = p[1]
	if(outside_map(x,y) or(board[x][y] == 'O')):
	    break
	if(x == a)  and (y == b):
	    dirEne = 5
	    return True

def is_hitable_mortar(a,b):
    global p, moDiffX, moDiffY
    moDiffX = a - p[0]
    moDiffY = b - p[1]
    if(max(math.fabs(moDiffX),math.fabs(moDiffY)) < 3 + levels[0]):
	return True
    else:
	return False

def attack_laser(dirr):
    valg = ["up", "down", "right-up", "right-down", "left-up", "left-down"]
    print("shooting %s-wards." % valg[dirr])
    transmitter.attack_laser(valg[dirr])

def upgradeable_laser():
    global ress, levels
    if(levels[1] == 2):
	return False
    if(ress[1] > 3 + levels[1]):
        return True
    else:
	return False

def upgradeable_mortar():
    global ress, levels
    if(levels[0] == 2):
	return False
    if(ress[0] > 3 + levels[0]):
        return True
    else:
	return False

def upgrade_laser():
    global ress, levels
    ress[1] = ress[1] - 4 + levels[1]
    levels[1] += 1
    transmitter.upgrade("laser")
def upgrade_mortar():
    global ress, levels
    ress[0] = ress[0] - 4 - levels[0]
    levels[0] += 1
    transmitter.upgrade("mortar")

def is_mineable(board):
    global p,ress,lastMined
    if(board[p[0]][p[1]] == 'E') or (board[p[0]][p[1]] == 'R') or (board[p[0]][p[1]] == 'C'):
	if(board[p[0]][p[1]] == 'E'):
	    ress[0] += 1
	    lastMined = 0
	elif(board[p[0]][p[1]] == 'R'):
	    ress[1] += 1
	    lastMined = 1
	elif(board[p[0]][p[1]] == 'C'):
	    ress[2] += 1
	    lastMined = 2
        return True
    else:
	return False

def allowed_move(board,a,b):
    global p, Y, X
    if(a > X-1) or (a < 0) or (b > Y-1) or (b < 0):
	return False
    if (board[a][b] == 'G') or (board[a][b] == 'E') or (board[a][b] == 'R') or (board[a][b] == 'C'):
	print("allowed")
        return True
    else:
        return False


    

def do_semiRandom_move(board):
    global p, X, Y, bestDir
    while(1):
	choice = random.randrange(0,6)
	x = p[0]
	y = p[1]
	if(choice == 0) and (allowed_move(board,x-1, y-1)):
	    a = x-1
	    b = y-1
	    direction = "up"
	    break
	elif(choice == 1) and (allowed_move(board,x+1, y+1)):
	    direction = "down"
	    a = x+1
	    b = y+1
	    break
	elif(choice == 2) and (allowed_move(board,x+1, y)):
	    direction = "left-down"
	    a = x+1
	    b = y
	    break
	elif(choice == 3) and (allowed_move(board,x, y-1)):
	    direction = "left-up"
	    a = x
	    b = y-1
	    break
	elif(choice == 4) and (allowed_move(board,x, y+1)):
	    direction = "right-down"
	    a = x
	    b = y+1
	    break
	elif(choice == 5) and (allowed_move(board,x-1, y)):
	    direction = "right-up"
	    a = x-1
	    b = y
	    break
    p[0] = a #update with new position
    p[1] = b
    bestDir = choice
    print("moving %s-wards." % direction)
    #transmitter.send_move(direction)

def do_move(dirr):
    dirrs = ["up", "down", "left-down", "left-up", "right-down", "right-up"]
    transmitter.send_move(dirrs[dirr])
def send_line(line): # sends a line to the socket
    print("sending: '%s'" % line)
    if sock.sendall(line + "\n") != None:
        print("Error sending data!")

def got_handshake():
    print("got handshake!")

def got_error(errmsg):
    if("mine" in errmsg):
        ress[lastMined] -= 1 #quickfix
    print("Error: '%s'" % errmsg)

def got_gamestate(turn, x, y, board, player_list):
    global p, ress, levels, X, Y, dirEne, bestDir
    tiMined = 0
    X = x
    Y = y
    if player_list[0]["name"] == sys.argv[1]: # its our turn
	steps = 0
	p = player_list[0]["position"].split(', ')
	levels[1] = int(player_list[0]["primary-weapon"]["level"]) - 1
	levels[0] = int(player_list[0]["secondary-weapon"]["level"]) - 1
	p[0] = int(p[0])
	p[1] = int(p[1])

	while(steps < 3):
	    steps += 1
	    print(ress)
	    print(levels)
	    for i in range(1, len(player_list)):
	        #print(player_list[i]["name"])
		l = player_list[i]["position"].split(', ')
	    	if(is_hitable_laser(board,int(l[0]),int(l[1]))):
		    attack_laser(dirEne)
		    break
	    for i in range(1, len(player_list)):
		l = player_list[i]["position"].split(', ')
	    	if(is_hitable_mortar(int(l[0]),int(l[1]))):
		    transmitter.attack_mortar(moDiffX, moDiffY)
		    break
	    if(upgradeable_laser()):
		upgrade_laser()
		continue

	    if(upgradeable_mortar()):
		upgrade_mortar()
		continue

	    if(tiMined < 2) and (is_mineable(board)):
	        transmitter.mine()
		tiMined += 1
		print("GRAVER")
		continue

            do_semiRandom_move(board)
	    do_move(bestDir)
        
def got_gamestart(turn, map_obj, player_list):
    weapons = ["mortar", "droid", "laser"]
    primary_weapon = "laser"
    secondary_weapon = "mortar"
    print("chose loadout: %s and %s" % (primary_weapon, secondary_weapon))
    global weapons_chosen
    weapons_chosen = [primary_weapon, secondary_weapon]
    transmitter.send_loadout(primary_weapon, secondary_weapon)

def got_action(action_type, who, rest_data):
    print("got action!")

def got_endturn():
    print("got endturn!")

#api stuff 
receiver = skyals.SkyportReceiver()
transmitter = skyals.SkyportTransmitter(send_line)
receiver.handler_handshake_successful = got_handshake
receiver.handler_error = got_error
receiver.handler_gamestate = got_gamestate
receiver.handler_gamestart = got_gamestart
receiver.handler_action = got_action
receiver.handler_endturn = got_endturn

# send the initial handshake
transmitter.send_handshake(sys.argv[1])

while True:
    line = read_packet() # try to read a line from the socket
    if line != None:
        receiver.parse_line(line) # hand the line to SkyportReceiver to process

