package aborysa.PowerShot.net;

import java.io.IOException;
import java.net.UnknownHostException;
import org.json.*;
public class ClientHandle {
	Client client;
	int port;
	String addr;
	public String name;
	String[] str;
	boolean connected = false;
	public ClientHandle(String addr, int port, String name){
		this.port = port;
		this.addr = addr;
		this.name = name;
		connect();
	}
	public boolean isConnected(){
		return connected;
	}
	private boolean connect(){
		try {
			client = new Client(addr, port);
			sendHand();
			System.out.println("Waiting for hand");
			String message = receive();
			JSONObject status = new JSONObject(message);
			String str = "connect";
			if (status.getBoolean("status")){
				System.out.println("Connected!");
				connected = true;
			}
			else{
				System.out.println("Did not connect correctly!");
				connected = false;
			}
			return connected;
		} catch (UnknownHostException e) {
			System.out.println(e);
			return false;
		} catch (IOException e) {
			System.out.println(e);
			return false;
		} catch(JSONException e){
			System.out.println(e);
			return false;
		}
				
	}
	private void sendHand(){
		JSONObject message = new JSONObject().put("message", "connect").put("revision",1).put("name", name);
		client.SendData(message.toString());
	}
	public void sendJSONObject(JSONObject obj){
		client.SendData(obj.toString());
	}
	
	public void sendLoadOut(String p, String s){
		System.out.println("SENDING LOADOUT!");
		JSONObject message = new JSONObject().put("message", "loadout").put("primary-weapon", p).put("secondary-weapon",s);
		client.SendData(message.toString());
	}
	/*public void sendAction(String actionType, String actionKey, Object actionValue){
		JSONObject message = new JSONObject();
		message.put("message", "action").put("type", actionType).put(actionKey,actionValue.toString()).put("from",name);
		client.SendData(message.toString());
	}*/
	
	public void sendAction(String actionType, String actionKey, Object actionValue){
		JSONObject message = new JSONObject();
		message.put("message", "action").put("type", actionType).put(actionKey,actionValue.toString()).put("from",name);

		client.SendData(message.toString());
	}	
	public void sendAction(String actionType, String actionKey, JSONArray actionValue){
		JSONObject message = new JSONObject();
		message.put("message", "action").put("type", actionType).put(actionKey,actionValue).put("from",name);
		client.SendData(message.toString());
	}


	public String receive(){
		return client.receive();
	}
}
