package aborysa.PowerShot.AI;

import aborysa.PowerShot.Map.Map;
import aborysa.PowerShot.Map.MapAnalyzer;
import aborysa.PowerShot.net.ClientHandle;

public class PowerShotAI {
	Controller controller;
	Map map;
	Bot[] bots;
	int hp = 100;
	int j, k, PL, SL;
	String PRW, SDW;
	String mainR;
	String secR;
	public PowerShotAI(String name, String ip, int port){
		ClientHandle Chandle = new ClientHandle(ip,port,name);
		controller = new Controller(Chandle);
		map = controller.map;
		controller.readMessage();
		updateInfo();
		chooseWeapon();
	}
	public void chooseWeapon(){
		MapAnalyzer tempA = controller.mapAnalyzer;
		int R = tempA.Rubidium;
		int O = tempA.Rock;
		int S = tempA.Scrap;
		int E = tempA.Explodium;
		int V = tempA.Void;
		int G = tempA.Grass;
		
		int hIndex = 0;
		int mIndex = -1;
		String PW = null, SW = null;
		int[] wep = new int[3]; //0 ->laser, 1 ->mortar, 3 ->droid0
		wep[0] = (int)(R * 10 + (V*0.25) - (O));
		wep[1] = (int)(E * 10 + 0.25*(O+V) - G*0.15);
		wep[2] = (int)( S * 10  - 0.5*(O + V));
		for (int i=0; i< 3;i++){
			if (wep[i] > wep[hIndex]){
				hIndex = i;
			}
		}
		for (int i=0; i< 3;i++){
			if ((mIndex == -1 || wep[i] > wep[mIndex])&& hIndex !=i) {
				mIndex = i;
			}
		}
		switch(hIndex){
		case 0:
			PW = "laser";
			mainR = "R";
		break;
		case 1:
			PW = "mortar";
			mainR = "E";
		break;
		case 2:
			PW = "droid";
			mainR = "C";
		break;
		}
		switch(mIndex){
		case 0:
			SW = "laser";
			secR = "R";
		break;
		case 1:
			SW = "mortar";
			secR = "E";
		break;
		case 2:
			SW = "droid";
			secR = "C";
		break;
		}
		controller.chooseWeapon(PW, SW);
	}
		
	
	public void updateInfo(){
		map = controller.map;
	}
	
	public boolean checkForUpgrade(){
		if ((controller.PL) < 3){
			if (mainR == "R" && controller.R >= 3 + controller.PL) {
				controller.upgrade("laser");
				controller.PL++;
				return true;
			}else if(mainR == "E" && controller.E >= 3 + controller.PL) {
				controller.upgrade("mortar");
				controller.PL++;
				return true;
			}else if(mainR == "C" && controller.C >= 3 + controller.PL) {
				controller.upgrade("droid");
				controller.PL++;
				return true;
			}
		}else if ((controller.SL) < 3){
			if (secR == "R" && controller.R >= 3 + controller.SL) {
				controller.upgrade("laser");
				controller.SL++;
				return true;
			}else if(secR == "E" && controller.E >= 3 + controller.SL) {
				controller.upgrade("mortar");
				controller.SL++;
				return true;
			}else if(secR == "C" && controller.C >= 3 + controller.SL) {
				controller.upgrade("droid");
				controller.SL++;
				return true;
			}
		}
		return false;
	}
	public void update(){
		controller.readMessage();
		updateInfo();
		int A = 0;
		int R = 0;
		boolean getRes = true;
		for(int i = 0; i < 3; i++){
			A = attackB();
			R = resB();
			
			if (checkForUpgrade()){
				System.out.println("DoingSHIT");
				continue;
			}
			if (getRes){
				if(map.getTile(k, j).equals(mainR)){
					if(controller.PL != 3){
						System.out.println("DoingSHIT");
						controller.mine();
						controller.mine();
						i++;
						getRes = false;
						continue;
					}
				}else if(map.getTile(k, j).equals(secR)){
					if(controller.SL != 3){
						System.out.println("DoingSHIT");
						controller.mine();
						controller.mine();
						i++;
						getRes = false;
						continue;
					}
				}
			}
			if ((A == 0) && (R == 0)){
				System.out.println("Attacking!");
				attackEnemie();
				continue;
			}else if (attackB() > resB()){
				System.out.println("DoingSHIT");
				attackMeth();
				break;
			}else if(!moveRes()){
				System.out.println("DoingSHIT");
				attackEnemie();
			}
		}
	}
	public void attackEnemie(){
		String[] path = controller.shortest();
		if (path !=null){
			controller.move(path[1]);
		}
	}
	public void attackMeth(){
		int dM = 0;
		int dL = 0;
		int dD = 0;
		int rest = 0;
		String use = "";
		int[] damageMortar = controller.totalDGranat();
		int[] damageLaser = controller.totalDLaser();
		String[] damageDroid = controller.totalDDroid();
		if (damageMortar != null){
			dM = damageMortar[0];
		}
		if (damageLaser !=null){
			dL = damageLaser[1];
		} 
		if (damageMortar!=null){
			dD = Integer.parseInt(damageDroid[0]);
		}
		if (dM > dD){
			use = "mortar";
			rest = dM;
		}else{
			use = "droid";
			rest = dD;
		}
		if(dL > rest){
			use = "laser";
		}
		if (use.equals("laser")){
			 String dir = controller.directions[damageLaser[0]];
			 controller.useLaser(dir);
		}
		if (use.equals("mortar")){
			controller.useMortar(damageMortar[1],damageMortar[2]);
		}
		if (use.equals("droid")){
			controller.useDroid(damageDroid);
		}
		
		
		
	}
	public int attackB(){
		int dM = 0;
		int dL = 0;
		int dD = 0;
		int[] damageMortar = controller.totalDGranat();
		int[] damageLaser = controller.totalDLaser();
		String[] damageDroid = controller.totalDDroid();
		if (damageMortar != null){
			dM = damageMortar[0];
		}
		if (damageLaser !=null){
			dL = damageLaser[1];
		} 
		if (damageDroid!=null){
			dD = Integer.parseInt(damageDroid[0]);
		}
		
		
		
		return Math.max(Math.max(dM,dL), dD);
	}
	public boolean moveRes(){
		int[] t = controller.benefitRes();
		String[] path = controller.findPath(k, j, t[1], t[2], 1);
		if (path != null){
			controller.move(path[1]);
			return true;
		}
		return false;
	}
	public int resB(){
		int[] t = controller.benefitRes();
		int benefit = t[0];
		return benefit;
	}
	
}
