#include <string.h>

#include "movement.h"
#include "map.h"
#include "bfs.h"
#include "main.h"

int movement_bfs_cb(int coords, int *camefrom, void *state)
{
    debug("BFS at %d %d, looking for %d %d\n",
        map_j_val(coords),
        map_k_val(coords),
        map_j_val(*((int *)state)),
        map_k_val(*((int *)state)));
    return coords == *((int *)state);
}

movement_t movement_towards(int from, int to)
{
    movement_t movement;
    movement.moves[0] = dir_none;
    movement.moves[1] = dir_none;
    movement.moves[2] = dir_none;
    movement.length = 0;

    /* BFS from 'from'. */
    int *camefrom = calloc(map_size, sizeof(int));
    bfs(from, camefrom, 0, movement_bfs_cb, &to);

    if (camefrom[to] == -1) {
        free(camefrom);
        return movement;
    }

    /* Backtrack from end. */
    int current = to;
    while (current != from) {
        movement.moves[2] = movement.moves[1];
        movement.moves[1] = movement.moves[0];
        movement.moves[0] = coords_to_dir(camefrom[current], current);
        current = camefrom[current];
        movement.length++;
    }

    free(camefrom);
    return movement;
}
