#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <assert.h>

#include "player.h"
#include "minimax.h"
#include "action.h"
#include "main.h"
#include "map.h"

int me_depth, max_depth = 2;

float utility(int depth)
{
    float penalty = 0;
    assert(me);
    if (map[map_coords(me->j, me->k)] == 'S') {
        penalty = 10;
    }
    debug("Returning utility %f from player %s\n",
        me->score, me->name);
    return me->score - penalty;
}

action_t selected_act;
int selected_param;

float alphabeta(int depth, float alpha, float beta)
{
    debug("alphabeta depth %d\n", depth);
    me_depth = 0;
    player_t *player = players;
    while (player) {
        if (player == me) {
            break;
        }
        player = player->next;
        me_depth++;
    }
    
    /* Check whether we're at the end of the search. */
    if (depth == max_depth) {
        float util = utility(depth);
        debug("alphabeta depth %d returning utility %f\n",
            depth, util);
        return util;
    }

    /* Initialize the value we want to optimize. */
    int max = (depth % player_count) == 0;
    float v;
    if (max) {
        v = INT_MIN;
    } else {
        v = INT_MAX;
    }

    /* Loop through all possible sub states. */
    for (int act_index = 0; act_index < act_max; act_index++) {
        action_t act = (action_t)act_index;
        int param_count = action_param_count(act);
        for (int param_val = 0; param_val < param_count; param_val++) {
            /* Call the action thingy. */
            float sub_value = action_wrap_minimax(
                act, param_val, depth, alpha, beta);
            debug("alphabeta depth %d got subvalue %f maximize %d\n",
                depth, sub_value, max);

            /* Update v with the better value. */
            float prev_v = v;
            if (max) {
                v = MAX(v, sub_value);
            } else {
                v = MIN(v, sub_value);
            }

            if (depth == 0 && v != prev_v) {
                debug("Setting act %d param %d\n", act, param_val);
                selected_act = act;
                selected_param = param_val;
            }

            /* Check for alpha-beta pruning. */
            if (max) {
                if (v >= beta) {
                    return v;
                }
            } else {
                if (v <= alpha) {
                    return v;
                }
            }

            /* Update alpha-beta values. */
            if (max) {
                alpha = MAX(alpha, v);
            } else {
                beta = MIN(beta, v);
            }
        }
    }

    return v;
}
