postprocessParameters = {}

function InitializeParameter(node, uniform, parameter)
	local str = node.."_"..uniform
	
	local initFunction = postprocessParameters[str]
	
	if (initFunction) then
		initFunction(parameter)
	end
end


postprocessParameters["ScrollingWaveform_fLineWidth"] =
	function(parameter)
		SetDefaultFloatValue(parameter,0.005)
	end

postprocessParameters["ScrollingWaveform_fRulerPosY"] =
	function(parameter)
		SetDefaultFloatValue(parameter,0.13)
	end

postprocessParameters["ScrollingWaveform_fRulerWidth"] =
	function(parameter)
		SetDefaultFloatValue(parameter,0.025)
	end


postprocessParameters["ScrollingWaveform_fGain"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.02)
	end

postprocessParameters["ScrollingWaveform_fFrequency"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 20.0)
	end

postprocessParameters["ScrollingWaveform_fRoughness"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.6375)
	end

postprocessParameters["ScrollingWaveform_fLacunarity"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 2.6)
	end
postprocessParameters["ScrollingWaveform_iNumOctaves"] =
	function(parameter)
		SetDefaultIntValue(parameter,6)
	end

postprocessParameters["ScrollingWaveform_fWaveformThickness"] =
	function(parameter)
		SetDefaultFloatValue(parameter,0.01)
	end

postprocessParameters["ScrollingWaveform_cLineColor"] = 
	function(parameter)
		SetDefaultColorValue(parameter, {0.03, 0.04, 0.175, 1.0})
	end

postprocessParameters["ScrollingWaveform_cRulerColor"] = 
	function(parameter)
		SetDefaultColorValue(parameter, {0.2, 0.1, 0.5, 1.0})
	end

postprocessParameters["ScrollingWaveform_cWaveformColor"] = 
	function(parameter)
		SetDefaultColorValue(parameter, {0.3, 0.3, 0.7, 1.0})
	end

postprocessParameters["Bricks_fBrickSize"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.2)
	end
	
postprocessParameters["Bricks_fLineWidth"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.005)
	end
	
postprocessParameters["CircleGen_fRadius"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end
	
postprocessParameters["CircleWaver_fFrequency"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 120.0)
	end
	
postprocessParameters["CircleWaver_fPhase"] =
	function(parameter)
		SetDefaultFloatValue(parameter, math.pi/2.0)
	end
	
postprocessParameters["CircleWaver_fExponent"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 1.4)
	end
	
postprocessParameters["CircleWaver_fOffset"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end
	
postprocessParameters["CircleWaver_fScale"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end
	
postprocessParameters["CircleWaver_fXCenter"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end
	
postprocessParameters["CircleWaver_fYCenter"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end
	
postprocessParameters["Clipper_fTop"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.8)
	end
	
postprocessParameters["Clipper_fRight"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.8)
	end
	
postprocessParameters["Clipper_fBottom"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.2)
	end
	
postprocessParameters["Clipper_fLeft"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.2)
	end
	
postprocessParameters["ColorMapper_fColor0Offset"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.2)
	end
	
postprocessParameters["ColorMapper_fColor0Width"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.2)
	end
	
postprocessParameters["ColorMapper_cColor0"] =
	function(parameter)
		SetDefaultColorValue(parameter, {0.0, 0.0, 0.0, 1.0})
	end

postprocessParameters["Cross-Hatching_iHatch_y_offset"] =
	function(parameter)
		SetDefaultIntValue(parameter, 5)
	end

postprocessParameters["Cross-Hatching_fLum_threshold_1"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 1.0)
	end

postprocessParameters["Cross-Hatching_fLum_threshold_2"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.7)
	end

postprocessParameters["Cross-Hatching_fLum_threshold_3"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end

postprocessParameters["Cross-Hatching_fLum_threshold_4"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.3)
	end

postprocessParameters["Desaturate_fDesaturation"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end

postprocessParameters["DirectionalBlur_fLength"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.01)
		SetDragScale(parameter, 0.05)
	end

postprocessParameters["DirectionalBlur_fPhase"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.0)
	end

postprocessParameters["DirectionalBlur_fLengthModulation"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.01)
		SetDragScale(parameter, 0.05)
	end

postprocessParameters["DirectionalBlur_fPhaseModulation"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end

postprocessParameters["Displacer_fFreqX"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end

postprocessParameters["Displacer_fFreqY"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end

postprocessParameters["Displacer_fZoom"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 1.0)
	end

postprocessParameters["Displacer_fExpo"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.0)
	end

postprocessParameters["Displacer_iType"] =
	function(parameter)
		AddParameterOption(parameter, 0, "Sin")
		AddParameterOption(parameter, 1, "Cos")
		AddParameterOption(parameter, 2, "Tan")
		AddParameterOption(parameter, 3, "ArcTan")
		SetDefaultOptionValue(parameter, 1)
	end

postprocessParameters["GlassTile_fSize"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 2.0)
	end

postprocessParameters["JuliaSet_fCx"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.0)
	end

postprocessParameters["JuliaSet_fCy"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.0)
	end

postprocessParameters["JuliaSet_iMaxIteration"] =
	function(parameter)
		SetDefaultIntValue(parameter, 20)
	end

postprocessParameters["Kaleidoskop_fZoom"] =
	function(parameter)
		SetDefaultFloatValue(parameter, -2.0)
	end

postprocessParameters["Kaleidoskop_iNumRotations"] =
	function(parameter)
		SetDefaultIntValue(parameter, 5)
	end
postprocessParameters["Kaleidoskop_fDisplaceX"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0)
	end
postprocessParameters["Kaleidoskop_fDisplaceY"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0)
	end

postprocessParameters["Kaleidoskop_iZoomType"] =
	function(parameter)
		AddParameterOption(parameter, 0, "Normal Zoom")
		AddParameterOption(parameter, 1, "Psychedelic")
		SetDefaultOptionValue(parameter, 0)
	end
	
postprocessParameters["Lensflare_fRadius"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.8)
	end
	
postprocessParameters["Lensflare_fFlareWidth"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.01)
	end
	
postprocessParameters["Lensflare_fBrightness"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end

postprocessParameters["Lensflare_cFlareColor"] =
	function(parameter)
		SetDefaultColorValue(parameter, {0.8, 0.7, 0.3, 1.0})
	end

postprocessParameters["LinearColor_cColor0"] =
	function(parameter)
		SetDefaultColorValue(parameter, {0.0, 0.0, 0.0, 1.0})
	end

postprocessParameters["LinearColor_cColor1"] =
	function(parameter)
		SetDefaultColorValue(parameter, {1.0, 1.0, 1.0, 1.0})
	end
	
postprocessParameters["MandelbrotSet_fCx"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.0)
	end

postprocessParameters["MandelbrotSet_fCy"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.0)
	end

postprocessParameters["MandelbrotSet_iMaxIteration"] =
	function(parameter)
		SetDefaultIntValue(parameter, 15)
	end

postprocessParameters["MandelbrotSet_fScale"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 5.0)
	end

postprocessParameters["Mix_iColorOp"] =
	function(parameter)
		AddParameterOption(parameter, 0, "Add")
		AddParameterOption(parameter, 1, "Multiply")
		AddParameterOption(parameter, 2, "Difference")
		AddParameterOption(parameter, 3, "L minus R")
		AddParameterOption(parameter, 4, "R minus L")
		AddParameterOption(parameter, 5, "Lighten")
		AddParameterOption(parameter, 6, "Darken")
		AddParameterOption(parameter, 7, "XOR")
		SetDefaultOptionValue(parameter, 0)
	end
	
postprocessParameters["Mix_iAlphaOp"] =
	function(parameter)
		AddParameterOption(parameter, 0, "Add")
		AddParameterOption(parameter, 1, "Multiply")
		AddParameterOption(parameter, 2, "Left")
		AddParameterOption(parameter, 3, "Right")
		SetDefaultOptionValue(parameter, 0)
	end
	
postprocessParameters["Offset_fXOffset"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.0)
	end

postprocessParameters["Offset_fXOffset"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.0)
	end

postprocessParameters["Offset_iXWrap"] =
	function(parameter)
		AddParameterOption(parameter, 0, "Clamp")
		AddParameterOption(parameter, 1, "Wrap")
		SetDefaultOptionValue(parameter, 0)
	end
	
postprocessParameters["Offset_iYWrap"] =
	function(parameter)
		AddParameterOption(parameter, 0, "Clamp")
		AddParameterOption(parameter, 1, "Wrap")
		SetDefaultOptionValue(parameter, 0)
	end
	
postprocessParameters["Overlay_iTopLayer"] =
	function(parameter)
		AddParameterOption(parameter, 0, "Left over Right")
		AddParameterOption(parameter, 1, "Right over Left")
		SetDefaultOptionValue(parameter, 0)
	end
	
postprocessParameters["PerlinNoise_iSeed"] =
	function(parameter)
		SetDefaultIntValue(parameter, 11)
	end

postprocessParameters["PerlinNoise_iStartOctave"] =
	function(parameter)
		SetDefaultIntValue(parameter, 1)
	end

postprocessParameters["PerlinNoise_iNumOctaves"] =
	function(parameter)
		SetDefaultIntValue(parameter, 5)
	end

postprocessParameters["PerlinNoise_fHeight"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end

postprocessParameters["PerlinNoise_fRandomness"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end

postprocessParameters["PerlinNoise_fRoughness"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end

postprocessParameters["PerlinNoise_iType"] =
	function(parameter)
		AddParameterOption(parameter, 0, "Normal")
		AddParameterOption(parameter, 1, "Absolute")
		SetDefaultOptionValue(parameter, 0)
	end

postprocessParameters["Pixelation_iNumPixelsX"] =
	function(parameter)
		SetDefaultIntValue(parameter, 10)
	end

postprocessParameters["Pixelation_iNumPixelsY"] =
	function(parameter)
		SetDefaultIntValue(parameter, 15)
	end

postprocessParameters["Posterization_fGamma"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.6)
	end

postprocessParameters["Posterization_fNumColors"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 8.0)
	end

postprocessParameters["Retrofilm_fNuance"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.2)
	end

postprocessParameters["Retrofilm_fExpose"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.2)
	end

postprocessParameters["Retrofilm_iNumLines"] =
	function(parameter)
		SetDefaultIntValue(parameter, 5)
	end

postprocessParameters["Retrofilm_fLineWidth"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.0001)
	end

postprocessParameters["Retrofilm_fSeed"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.7)
	end

postprocessParameters["Retrofilm_fDarkCorner"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.54)
	end

postprocessParameters["Rotozoom_fZoom"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 1.0)
	end

postprocessParameters["Rotozoom_iRotation"] =
	function(parameter)
		SetDefaultIntValue(parameter, 0)
	end

postprocessParameters["Rotozoom_iRepeat"] =
	function(parameter)
		AddParameterOption(parameter, 0, "Clamp")
		AddParameterOption(parameter, 1, "Wrap")
		SetDefaultOptionValue(parameter, 0)
	end
	
postprocessParameters["Supershape_fScale"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.25)
	end
	
postprocessParameters["Supershape_fN1"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 1.0)
	end
	
postprocessParameters["Supershape_fN2"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 1.0)
	end
	
postprocessParameters["Supershape_fN3"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 1.0)
	end
	
postprocessParameters["Supershape_fA"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 1.0)
	end
	
postprocessParameters["Supershape_fB"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 1.0)
	end
	
postprocessParameters["Supershape_iM"] =
	function(parameter)
		SetDefaultIntValue(parameter, 3)
	end
	
postprocessParameters["Supershape_fTransition"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 5.0)
	end

postprocessParameters["Swirl_fRadius"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end

postprocessParameters["Swirl_fRotation"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 360.0)
	end

postprocessParameters["Swirl_fSinusFreq"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 1.0)
	end

postprocessParameters["Swirl_fSinusAmpl"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.0)
	end
	
postprocessParameters["Threshold_fThreshold"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end

postprocessParameters["Threshold_fSmoothness"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end
	
postprocessParameters["Threshold_iOp"] =
	function(parameter)
		AddParameterOption(parameter, 0, "Color = value, Alpha = 1")
		AddParameterOption(parameter, 1, "Color = 1, Alpha = value")
		AddParameterOption(parameter, 2, "Color = input, alpha = value")
		AddParameterOption(parameter, 3, "Color = input*value, alpha = input")
		SetDefaultOptionValue(parameter, 0)
	end
	
postprocessParameters["TransformColor_fScale"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 1.0)
	end

postprocessParameters["TransformColor_fOffset"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.0)
	end

postprocessParameters["TransformColor_iAlphaOp"] =
	function(parameter)
		AddParameterOption(parameter, 0, "Ignore Scala")
		AddParameterOption(parameter, 1, "Scale Scale")
		SetDefaultOptionValue(parameter, 0)
	end

postprocessParameters["SimplexFbm_iType"] =
	function(parameter)
		AddParameterOption(parameter, 0, "Normal")
		AddParameterOption(parameter, 1, "Abs")
		SetDefaultOptionValue(parameter, 0)
	end

postprocessParameters["SimplexFbm_fBaseFreq"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 3.0)
	end

postprocessParameters["SimplexFbm_fOffset"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end

postprocessParameters["SimplexFbm_fScale"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.5)
	end

postprocessParameters["SimplexFbm_fLacunarity"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 2.0)
	end

postprocessParameters["SimplexFbm_fRoughness"] =
	function(parameter)
		SetDefaultFloatValue(parameter, 0.85)
	end

postprocessParameters["SimplexFbm_iNumOctaves"] =
	function(parameter)
		SetDefaultIntValue(parameter, 3)
	end

postprocessParameters["SimplexFbm_iSeed"] =
	function(parameter)
		SetDefaultIntValue(parameter, 17841)
	end








function SetDragScale(parameter, value)
	parameter.dragScale = value
end

function SetDefaultFloatValue(parameter, value)
	parameter.floatValue = value
end

function SetDefaultIntValue(parameter, value)
	parameter.intValue = value
end

function SetDefaultColorValue(parameter, value)
	parameter.vectorValue:SetX(value[1])
	parameter.vectorValue:SetY(value[2])
	parameter.vectorValue:SetZ(value[3])
	parameter.vectorValue:SetW(value[4])
end

function AddParameterOption(parameter, value, str)
	parameter:SetOptionValue(parameter.numOptions, value)
	parameter:SetOptionName(parameter.numOptions, str)
	
	parameter.numOptions = parameter.numOptions + 1
end

function SetDefaultOptionValue(parameter, value)
	local index = nil
	
	for i=0,parameter.numOptions-1 do
		if (value==parameter:GetOptionValue(i)) then
			index = i
			break
		end
	end
	
	if (index) then
		parameter.intValue = parameter:GetOptionValue(index)
		parameter.stringValue = parameter:GetOptionName(index)
		parameter.type = intruder.ZParameter_kTypeOption
	end
end
